/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.nio.ByteBuffer;
import java.util.Locale;
import sun.font.CMap;
import sun.font.CharToGlyphMapper;
import sun.font.FontUtilities;
import sun.font.SunFontManager;
import sun.font.TrueTypeFont;

public class TrueTypeGlyphMapper
extends CharToGlyphMapper {
    static final char REVERSE_SOLIDUS = '\\';
    static final char JA_YEN = '\u00a5';
    static final char JA_FULLWIDTH_TILDE_CHAR = '\uff5e';
    static final char JA_WAVE_DASH_CHAR = '\u301c';
    static final boolean isJAlocale = Locale.JAPAN.equals(Locale.getDefault());
    private final boolean needsJAremapping;
    private boolean remapJAWaveDash;
    TrueTypeFont font;
    CMap cmap;
    int numGlyphs;

    public TrueTypeGlyphMapper(TrueTypeFont trueTypeFont) {
        this.font = trueTypeFont;
        try {
            this.cmap = CMap.initialize(trueTypeFont);
        }
        catch (Exception exception) {
            this.cmap = null;
        }
        if (this.cmap == null) {
            this.handleBadCMAP();
        }
        this.missingGlyph = 0;
        ByteBuffer byteBuffer = trueTypeFont.getTableBuffer(1835104368);
        this.numGlyphs = byteBuffer.getChar(4);
        if (FontUtilities.isSolaris && isJAlocale && trueTypeFont.supportsJA()) {
            this.needsJAremapping = true;
            if (FontUtilities.isSolaris8 && this.getGlyphFromCMAP(12316) == this.missingGlyph) {
                this.remapJAWaveDash = true;
            }
        } else {
            this.needsJAremapping = false;
        }
    }

    @Override
    public int getNumGlyphs() {
        return this.numGlyphs;
    }

    private char getGlyphFromCMAP(int n) {
        try {
            char c = this.cmap.getGlyph(n);
            if (c < this.numGlyphs || c >= '\ufffe') {
                return c;
            }
            if (FontUtilities.isLogging()) {
                FontUtilities.getLogger().warning(this.font + " out of range glyph id=" + Integer.toHexString(c) + " for char " + Integer.toHexString(n));
            }
            return (char)this.missingGlyph;
        }
        catch (Exception exception) {
            this.handleBadCMAP();
            return (char)this.missingGlyph;
        }
    }

    private void handleBadCMAP() {
        if (FontUtilities.isLogging()) {
            FontUtilities.getLogger().severe("Null Cmap for " + this.font + "substituting for this font");
        }
        SunFontManager.getInstance().deRegisterBadFont(this.font);
        this.cmap = CMap.theNullCmap;
    }

    private final char remapJAChar(char c) {
        switch (c) {
            case '\\': {
                return '\u00a5';
            }
            case '\u301c': {
                if (!this.remapJAWaveDash) break;
                return '\uff5e';
            }
        }
        return c;
    }

    private final int remapJAIntChar(int n) {
        switch (n) {
            case 92: {
                return 165;
            }
            case 12316: {
                if (!this.remapJAWaveDash) break;
                return 65374;
            }
        }
        return n;
    }

    @Override
    public int charToGlyph(char c) {
        if (this.needsJAremapping) {
            c = this.remapJAChar(c);
        }
        char c2 = this.getGlyphFromCMAP(c);
        if (this.font.checkUseNatives() && c2 < this.font.glyphToCharMap.length) {
            this.font.glyphToCharMap[c2] = c;
        }
        return c2;
    }

    @Override
    public int charToGlyph(int n) {
        if (this.needsJAremapping) {
            n = this.remapJAIntChar(n);
        }
        char c = this.getGlyphFromCMAP(n);
        if (this.font.checkUseNatives() && c < this.font.glyphToCharMap.length) {
            this.font.glyphToCharMap[c] = (char)n;
        }
        return c;
    }

    @Override
    public void charsToGlyphs(int n, int[] nArray, int[] nArray2) {
        for (int i = 0; i < n; ++i) {
            nArray2[i] = this.needsJAremapping ? (int)this.getGlyphFromCMAP(this.remapJAIntChar(nArray[i])) : (int)this.getGlyphFromCMAP(nArray[i]);
            if (!this.font.checkUseNatives() || nArray2[i] >= this.font.glyphToCharMap.length) continue;
            this.font.glyphToCharMap[nArray2[i]] = (char)nArray[i];
        }
    }

    @Override
    public void charsToGlyphs(int n, char[] cArray, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            char c;
            int n2 = this.needsJAremapping ? this.remapJAChar(cArray[i]) : cArray[i];
            if (n2 >= 55296 && n2 <= 56319 && i < n - 1 && (c = cArray[i + 1]) >= '\udc00' && c <= '\udfff') {
                n2 = (n2 - 55296) * 1024 + c - 56320 + 65536;
                nArray[i] = this.getGlyphFromCMAP(n2);
                nArray[++i] = 65535;
                continue;
            }
            nArray[i] = this.getGlyphFromCMAP(n2);
            if (!this.font.checkUseNatives() || nArray[i] >= this.font.glyphToCharMap.length) continue;
            this.font.glyphToCharMap[nArray[i]] = (char)n2;
        }
    }

    @Override
    public boolean charsToGlyphsNS(int n, char[] cArray, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            char c;
            int n2 = this.needsJAremapping ? this.remapJAChar(cArray[i]) : cArray[i];
            if (n2 >= 55296 && n2 <= 56319 && i < n - 1 && (c = cArray[i + 1]) >= '\udc00' && c <= '\udfff') {
                n2 = (n2 - 55296) * 1024 + c - 56320 + 65536;
                nArray[i + 1] = 65535;
            }
            nArray[i] = this.getGlyphFromCMAP(n2);
            if (this.font.checkUseNatives() && nArray[i] < this.font.glyphToCharMap.length) {
                this.font.glyphToCharMap[nArray[i]] = (char)n2;
            }
            if (n2 < 768) continue;
            if (FontUtilities.isComplexCharCode(n2)) {
                return true;
            }
            if (n2 < 65536) continue;
            ++i;
        }
        return false;
    }

    boolean hasSupplementaryChars() {
        return this.cmap instanceof CMap.CMapFormat8 || this.cmap instanceof CMap.CMapFormat10 || this.cmap instanceof CMap.CMapFormat12;
    }
}

