/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.ws.spi;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.spi.FactoryFinder;
import javax.xml.ws.spi.Invoker;
import javax.xml.ws.spi.ServiceDelegate;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;

public abstract class Provider {
    public static final String JAXWSPROVIDER_PROPERTY = "javax.xml.ws.spi.Provider";
    static final String DEFAULT_JAXWSPROVIDER = "com.sun.xml.internal.ws.spi.ProviderImpl";
    private static final Method loadMethod;
    private static final Method iteratorMethod;

    protected Provider() {
    }

    public static Provider provider() {
        try {
            Object object = Provider.getProviderUsingServiceLoader();
            if (object == null) {
                object = FactoryFinder.find(JAXWSPROVIDER_PROPERTY, DEFAULT_JAXWSPROVIDER);
            }
            if (!(object instanceof Provider)) {
                Class<Provider> clazz = Provider.class;
                String string = clazz.getName().replace('.', '/') + ".class";
                ClassLoader classLoader = clazz.getClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                URL uRL = classLoader.getResource(string);
                throw new LinkageError("ClassCastException: attempting to cast" + object.getClass().getClassLoader().getResource(string) + "to" + uRL.toString());
            }
            return (Provider)object;
        }
        catch (WebServiceException webServiceException) {
            throw webServiceException;
        }
        catch (Exception exception) {
            throw new WebServiceException("Unable to createEndpointReference Provider", exception);
        }
    }

    private static Provider getProviderUsingServiceLoader() {
        if (loadMethod != null) {
            Iterator iterator;
            Object object;
            try {
                object = loadMethod.invoke(null, Provider.class);
            }
            catch (Exception exception) {
                throw new WebServiceException("Cannot invoke java.util.ServiceLoader#load()", exception);
            }
            try {
                iterator = (Iterator)iteratorMethod.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                throw new WebServiceException("Cannot invoke java.util.ServiceLoader#iterator()", exception);
            }
            return iterator.hasNext() ? (Provider)iterator.next() : null;
        }
        return null;
    }

    public abstract ServiceDelegate createServiceDelegate(URL var1, QName var2, Class<? extends Service> var3);

    public ServiceDelegate createServiceDelegate(URL uRL, QName qName, Class<? extends Service> clazz, WebServiceFeature ... webServiceFeatureArray) {
        throw new UnsupportedOperationException("JAX-WS 2.2 implementation must override this default behaviour.");
    }

    public abstract Endpoint createEndpoint(String var1, Object var2);

    public abstract Endpoint createAndPublishEndpoint(String var1, Object var2);

    public abstract EndpointReference readEndpointReference(Source var1);

    public abstract <T> T getPort(EndpointReference var1, Class<T> var2, WebServiceFeature ... var3);

    public abstract W3CEndpointReference createW3CEndpointReference(String var1, QName var2, QName var3, List<Element> var4, String var5, List<Element> var6);

    public W3CEndpointReference createW3CEndpointReference(String string, QName qName, QName qName2, QName qName3, List<Element> list, String string2, List<Element> list2, List<Element> list3, Map<QName, String> map) {
        throw new UnsupportedOperationException("JAX-WS 2.2 implementation must override this default behaviour.");
    }

    public Endpoint createAndPublishEndpoint(String string, Object object, WebServiceFeature ... webServiceFeatureArray) {
        throw new UnsupportedOperationException("JAX-WS 2.2 implementation must override this default behaviour.");
    }

    public Endpoint createEndpoint(String string, Object object, WebServiceFeature ... webServiceFeatureArray) {
        throw new UnsupportedOperationException("JAX-WS 2.2 implementation must override this default behaviour.");
    }

    public Endpoint createEndpoint(String string, Class<?> clazz, Invoker invoker, WebServiceFeature ... webServiceFeatureArray) {
        throw new UnsupportedOperationException("JAX-WS 2.2 implementation must override this default behaviour.");
    }

    static {
        Method method = null;
        Method method2 = null;
        try {
            Class<?> clazz = Class.forName("java.util.ServiceLoader");
            method = clazz.getMethod("load", Class.class);
            method2 = clazz.getMethod("iterator", new Class[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        loadMethod = method;
        iteratorMethod = method2;
    }
}

