/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.function.BinaryOperator;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.IndexRange;
import org.reactfx.Subscription;
import org.reactfx.collection.ListReduction;
import org.reactfx.util.Experimental;
import org.reactfx.value.Val;

@Experimental
class ListRangeReduction<T>
extends ListReduction<T> {
    private final ObservableValue<IndexRange> range;

    ListRangeReduction(ObservableList<T> input, ObservableValue<IndexRange> range, BinaryOperator<T> reduction) {
        super(input, reduction);
        this.range = range;
    }

    @Override
    protected Subscription connect() {
        return super.connect().and(Val.observeInvalidations(this.range, obs -> this.invalidate()));
    }

    @Override
    protected int getFrom(int max) {
        return Math.min(this.range.getValue().getStart(), max);
    }

    @Override
    protected int getTo(int max) {
        return Math.min(this.range.getValue().getEnd(), max);
    }
}

