/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.flowless;

import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ChangeListener;
import javafx.css.PseudoClass;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Region;
import org.fxmisc.flowless.Virtualized;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class VirtualizedScrollPane<V extends Node>
extends Region
implements Virtualized {
    private static final PseudoClass CONTENT_FOCUSED = PseudoClass.getPseudoClass("content-focused");
    private final ScrollBar hbar;
    private final ScrollBar vbar;
    private final V content;
    private final ChangeListener<Boolean> contentFocusedListener;
    private Var<Double> hbarValue;
    private Var<Double> vbarValue;
    private final Var<ScrollPane.ScrollBarPolicy> hbarPolicy;
    private final Var<ScrollPane.ScrollBarPolicy> vbarPolicy;

    public final ScrollPane.ScrollBarPolicy getHbarPolicy() {
        return (ScrollPane.ScrollBarPolicy)((Object)this.hbarPolicy.getValue());
    }

    public final void setHbarPolicy(ScrollPane.ScrollBarPolicy value) {
        this.hbarPolicy.setValue(value);
    }

    public final Var<ScrollPane.ScrollBarPolicy> hbarPolicyProperty() {
        return this.hbarPolicy;
    }

    public final ScrollPane.ScrollBarPolicy getVbarPolicy() {
        return (ScrollPane.ScrollBarPolicy)((Object)this.vbarPolicy.getValue());
    }

    public final void setVbarPolicy(ScrollPane.ScrollBarPolicy value) {
        this.vbarPolicy.setValue(value);
    }

    public final Var<ScrollPane.ScrollBarPolicy> vbarPolicyProperty() {
        return this.vbarPolicy;
    }

    public VirtualizedScrollPane(@NamedArg(value="content") V content, @NamedArg(value="hPolicy") ScrollPane.ScrollBarPolicy hPolicy, @NamedArg(value="vPolicy") ScrollPane.ScrollBarPolicy vPolicy) {
        this.getStyleClass().add("virtualized-scroll-pane");
        this.content = content;
        this.hbar = new ScrollBar();
        this.vbar = new ScrollBar();
        this.hbar.setOrientation(Orientation.HORIZONTAL);
        this.vbar.setOrientation(Orientation.VERTICAL);
        this.hbar.setMin(0.0);
        this.vbar.setMin(0.0);
        this.hbar.maxProperty().bind(((Virtualized)content).totalWidthEstimateProperty());
        this.vbar.maxProperty().bind(((Virtualized)content).totalHeightEstimateProperty());
        VirtualizedScrollPane.setupUnitIncrement(this.hbar);
        VirtualizedScrollPane.setupUnitIncrement(this.vbar);
        this.hbar.blockIncrementProperty().bind(this.hbar.visibleAmountProperty());
        this.vbar.blockIncrementProperty().bind(this.vbar.visibleAmountProperty());
        Var<Double> hPosEstimate = Val.combine(((Virtualized)content).estimatedScrollXProperty(), Val.map(((Node)content).layoutBoundsProperty(), Bounds::getWidth), ((Virtualized)content).totalWidthEstimateProperty(), VirtualizedScrollPane::offsetToScrollbarPosition).asVar(this::setHPosition);
        Var<Double> vPosEstimate = Val.combine(((Virtualized)content).estimatedScrollYProperty(), Val.map(((Node)content).layoutBoundsProperty(), Bounds::getHeight), ((Virtualized)content).totalHeightEstimateProperty(), VirtualizedScrollPane::offsetToScrollbarPosition).orElseConst(0.0).asVar(this::setVPosition);
        this.hbarValue = Var.doubleVar(this.hbar.valueProperty());
        this.vbarValue = Var.doubleVar(this.vbar.valueProperty());
        Bindings.bindBidirectional(this.hbarValue, hPosEstimate);
        Bindings.bindBidirectional(this.vbarValue, vPosEstimate);
        this.hbarPolicy = Var.newSimpleVar(hPolicy);
        this.vbarPolicy = Var.newSimpleVar(vPolicy);
        Val<Double> layoutWidth = Val.map(this.layoutBoundsProperty(), Bounds::getWidth);
        Val<Double> layoutHeight = Val.map(this.layoutBoundsProperty(), Bounds::getHeight);
        Val<Boolean> needsHBar0 = Val.combine(((Virtualized)content).totalWidthEstimateProperty(), layoutWidth, (cw, lw) -> cw > lw);
        Val<Boolean> needsVBar0 = Val.combine(((Virtualized)content).totalHeightEstimateProperty(), layoutHeight, (ch, lh) -> ch > lh);
        Val<Boolean> needsHBar = Val.combine(needsHBar0, needsVBar0, ((Virtualized)content).totalWidthEstimateProperty(), this.vbar.widthProperty(), layoutWidth, (needsH, needsV, cw, vbw, lw) -> needsH != false || needsV != false && cw + vbw.doubleValue() > lw);
        Val<Boolean> needsVBar = Val.combine(needsVBar0, needsHBar0, ((Virtualized)content).totalHeightEstimateProperty(), this.hbar.heightProperty(), layoutHeight, (needsV, needsH, ch, hbh, lh) -> needsV != false || needsH != false && ch + hbh.doubleValue() > lh);
        Val shouldDisplayHorizontal = Val.flatMap(this.hbarPolicy, policy -> {
            switch (policy) {
                case NEVER: {
                    return Val.constant(false);
                }
                case ALWAYS: {
                    return Val.constant(true);
                }
            }
            return needsHBar;
        });
        Val shouldDisplayVertical = Val.flatMap(this.vbarPolicy, policy -> {
            switch (policy) {
                case NEVER: {
                    return Val.constant(false);
                }
                case ALWAYS: {
                    return Val.constant(true);
                }
            }
            return needsVBar;
        });
        shouldDisplayHorizontal.addListener(obs -> Platform.runLater(this::requestLayout));
        shouldDisplayVertical.addListener(obs -> Platform.runLater(this::requestLayout));
        this.hbar.visibleProperty().bind(shouldDisplayHorizontal);
        this.vbar.visibleProperty().bind(shouldDisplayVertical);
        this.contentFocusedListener = (obs, ov, nv) -> this.pseudoClassStateChanged(CONTENT_FOCUSED, (boolean)nv);
        ((Node)content).focusedProperty().addListener(this.contentFocusedListener);
        this.getChildren().addAll((Node[])new Node[]{content, this.hbar, this.vbar});
        this.getChildren().addListener(obs -> this.dispose());
    }

    public VirtualizedScrollPane(@NamedArg(value="content") V content) {
        this(content, ScrollPane.ScrollBarPolicy.AS_NEEDED, ScrollPane.ScrollBarPolicy.AS_NEEDED);
    }

    public V getContent() {
        return this.content;
    }

    public V removeContent() {
        this.getChildren().clear();
        return this.content;
    }

    private void dispose() {
        ((Node)this.content).focusedProperty().removeListener(this.contentFocusedListener);
        this.hbarValue.unbindBidirectional(((Virtualized)this.content).estimatedScrollXProperty());
        this.vbarValue.unbindBidirectional(((Virtualized)this.content).estimatedScrollYProperty());
        this.unbindScrollBar(this.hbar);
        this.unbindScrollBar(this.vbar);
    }

    private void unbindScrollBar(ScrollBar bar) {
        bar.maxProperty().unbind();
        bar.unitIncrementProperty().unbind();
        bar.blockIncrementProperty().unbind();
        bar.visibleProperty().unbind();
    }

    @Override
    public Val<Double> totalWidthEstimateProperty() {
        return ((Virtualized)this.content).totalWidthEstimateProperty();
    }

    @Override
    public Val<Double> totalHeightEstimateProperty() {
        return ((Virtualized)this.content).totalHeightEstimateProperty();
    }

    @Override
    public Var<Double> estimatedScrollXProperty() {
        return ((Virtualized)this.content).estimatedScrollXProperty();
    }

    @Override
    public Var<Double> estimatedScrollYProperty() {
        return ((Virtualized)this.content).estimatedScrollYProperty();
    }

    @Override
    public void scrollXBy(double deltaX) {
        ((Virtualized)this.content).scrollXBy(deltaX);
    }

    @Override
    public void scrollYBy(double deltaY) {
        ((Virtualized)this.content).scrollYBy(deltaY);
    }

    @Override
    public void scrollXToPixel(double pixel) {
        ((Virtualized)this.content).scrollXToPixel(pixel);
    }

    @Override
    public void scrollYToPixel(double pixel) {
        ((Virtualized)this.content).scrollYToPixel(pixel);
    }

    @Override
    protected double computePrefWidth(double height) {
        return ((Node)this.content).prefWidth(height);
    }

    @Override
    protected double computePrefHeight(double width) {
        return ((Node)this.content).prefHeight(width);
    }

    @Override
    protected double computeMinWidth(double height) {
        return this.vbar.minWidth(-1.0);
    }

    @Override
    protected double computeMinHeight(double width) {
        return this.hbar.minHeight(-1.0);
    }

    @Override
    protected double computeMaxWidth(double height) {
        return ((Node)this.content).maxWidth(height);
    }

    @Override
    protected double computeMaxHeight(double width) {
        return ((Node)this.content).maxHeight(width);
    }

    @Override
    protected void layoutChildren() {
        double layoutWidth = this.getLayoutBounds().getWidth();
        double layoutHeight = this.getLayoutBounds().getHeight();
        boolean vbarVisible = this.vbar.isVisible();
        boolean hbarVisible = this.hbar.isVisible();
        double vbarWidth = vbarVisible ? this.vbar.prefWidth(-1.0) : 0.0;
        double hbarHeight = hbarVisible ? this.hbar.prefHeight(-1.0) : 0.0;
        double w = layoutWidth - vbarWidth;
        double h = layoutHeight - hbarHeight;
        ((Node)this.content).resize(w, h);
        this.hbar.setVisibleAmount(w);
        this.vbar.setVisibleAmount(h);
        if (vbarVisible) {
            this.vbar.resizeRelocate(layoutWidth - vbarWidth, 0.0, vbarWidth, h);
        }
        if (hbarVisible) {
            this.hbar.resizeRelocate(0.0, layoutHeight - hbarHeight, w, hbarHeight);
        }
    }

    private void setHPosition(double pos) {
        double offset = VirtualizedScrollPane.scrollbarPositionToOffset(pos, ((Node)this.content).getLayoutBounds().getWidth(), (Double)((Virtualized)this.content).totalWidthEstimateProperty().getValue());
        ((Virtualized)this.content).estimatedScrollXProperty().setValue(offset);
    }

    private void setVPosition(double pos) {
        double offset = VirtualizedScrollPane.scrollbarPositionToOffset(pos, ((Node)this.content).getLayoutBounds().getHeight(), (Double)((Virtualized)this.content).totalHeightEstimateProperty().getValue());
        ((Virtualized)this.content).estimatedScrollYProperty().setValue(offset);
    }

    private static void setupUnitIncrement(final ScrollBar bar) {
        bar.unitIncrementProperty().bind(new DoubleBinding(){
            {
                this.bind(bar.maxProperty(), bar.visibleAmountProperty());
            }

            @Override
            protected double computeValue() {
                double visible;
                double max = bar.getMax();
                return max > (visible = bar.getVisibleAmount()) ? 16.0 / (max - visible) * max : 0.0;
            }
        });
    }

    private static double offsetToScrollbarPosition(double contentOffset, double viewportSize, double contentSize) {
        return contentSize > viewportSize ? contentOffset / (contentSize - viewportSize) * contentSize : 0.0;
    }

    private static double scrollbarPositionToOffset(double scrollbarPos, double viewportSize, double contentSize) {
        return contentSize > viewportSize ? scrollbarPos / contentSize * (contentSize - viewportSize) : 0.0;
    }
}

