/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class FileObserver {
    private HashMap<WatchKey, WatchHolder> events = new HashMap();
    private AtomicBoolean running = new AtomicBoolean(true);
    private WatchService watcher;

    public FileObserver() {
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        FileObserver observer = new FileObserver();
        observer.registerListener(new File("bin").toPath(), System.out::println);
        observer.start();
    }

    public void registerListener(Path path, FileEventListener listener) {
        try {
            WatchKey register = path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            WatchHolder holder = new WatchHolder();
            holder.listener = listener;
            holder.path = path;
            this.events.put(register, holder);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void start() {
        new Thread(() -> {
            while (this.running.get()) {
                try {
                    WatchKey take = this.watcher.take();
                    WatchHolder holder = this.events.get(take);
                    List<WatchEvent<?>> watchEvents = take.pollEvents();
                    for (WatchEvent<?> event : watchEvents) {
                        FileEvent e = new FileEvent(event, holder.path);
                        try {
                            holder.listener.onFileEvent(e);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    take.reset();
                }
                catch (InterruptedException interruptedException) {}
            }
        }).start();
    }

    public void stop() {
        this.running.set(false);
        try {
            this.watcher.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class FileEvent {
        private final WatchEvent<?> event;
        private final Path path;

        private FileEvent(WatchEvent<?> event, Path path) {
            this.event = event;
            this.path = path;
        }

        public WatchEvent.Kind<Path> kind() {
            return this.event.kind();
        }

        public Path getPath() {
            return this.path.resolve((Path)this.event.context());
        }

        public String toString() {
            return "FileEvent{kind=" + this.kind() + ", path=" + this.getPath() + '}';
        }
    }

    private class WatchHolder {
        private Path path;
        private FileEventListener listener;

        private WatchHolder() {
        }
    }

    public static interface FileEventListener {
        public void onFileEvent(FileEvent var1);
    }
}

