/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem.utils;

import com.stirante.asem.utils.AsyncTask;
import java.util.concurrent.atomic.AtomicLong;

public class DelayedTask
extends AsyncTask<Void, Void, Void> {
    private final long delay;
    private Runnable runnable;
    private AtomicLong startTime = new AtomicLong(System.currentTimeMillis());

    public DelayedTask(long delay) {
        this.delay = delay;
    }

    public void start(Runnable r) {
        this.startTime.set(System.currentTimeMillis());
        this.runnable = r;
        this.execute(new Void[0]);
    }

    public Void doInBackground(Void[] params) {
        long timeToWait = this.delay - (System.currentTimeMillis() - this.startTime.get());
        while (timeToWait > 0L) {
            try {
                Thread.sleep(timeToWait);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            timeToWait = this.delay - (System.currentTimeMillis() - this.startTime.get());
        }
        return null;
    }

    @Override
    public void onPostExecute(Void result) {
        this.runnable.run();
    }
}

