/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem.ui.tooltip;

import com.stirante.asem.ui.CodeView;
import com.stirante.asem.ui.tooltip.DefaultTooltips;
import com.stirante.asem.ui.tooltip.TooltipContent;
import java.util.ArrayList;
import javafx.geometry.Point2D;
import javafx.scene.control.Label;
import javafx.stage.Popup;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.event.MouseOverTextEvent;
import org.fxmisc.richtext.model.TwoDimensional;

public class TooltipPopup
extends Popup {
    private final CodeView view;
    private final CodeArea codeArea;
    private final Label popupMsg;
    private final ArrayList<TooltipContent> contents = new ArrayList();

    public TooltipPopup(CodeView view, CodeArea codeArea) {
        this.view = view;
        this.codeArea = codeArea;
        this.popupMsg = new Label();
        this.popupMsg.setStyle("-fx-background-color: #2e2e2e;-fx-text-fill: #8a8a8a;-fx-border-color: white;-fx-padding: 5;");
        this.popupMsg.setWrapText(true);
        this.popupMsg.setMaxWidth(400.0);
        this.getContent().add(this.popupMsg);
    }

    public void triggerTooltip(MouseOverTextEvent e) {
        int chIdx = e.getCharacterIndex();
        Point2D pos = e.getScreenPosition();
        String s = this.view.getWordAt(chIdx);
        int line = this.codeArea.offsetToPosition(chIdx, TwoDimensional.Bias.Forward).getMajor() + 1;
        if (DefaultTooltips.getInstance().matches(s, chIdx, line)) {
            this.popupMsg.setText(DefaultTooltips.getInstance().getTooltipText(s, chIdx, line));
            this.show(this.codeArea, pos.getX() + 15.0, pos.getY() + 15.0);
            return;
        }
        for (TooltipContent content : this.getTooltips()) {
            if (!content.matches(s, chIdx, line)) continue;
            this.popupMsg.setText(content.getTooltipText(s, chIdx, line));
            this.show(this.codeArea, pos.getX() + 15.0, pos.getY() + 15.0);
            return;
        }
    }

    private ArrayList<TooltipContent> getTooltips() {
        ArrayList<TooltipContent> result = new ArrayList<TooltipContent>();
        result.add(DefaultTooltips.getInstance());
        result.addAll(this.view.getSyntaxAnalysis().getErrors());
        result.addAll(this.view.getSyntaxAnalysis().getCollisions());
        result.addAll(this.view.getSyntaxAnalysis().getRoutines());
        result.addAll(this.view.getSyntaxAnalysis().getFields());
        return result;
    }
}

