/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem.ui;

import com.fo.controls.fontpicker.FontPicker;
import com.stirante.asem.utils.ConfigManager;
import com.stirante.asem.utils.SerializableFont;
import java.util.HashMap;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;

public class Settings {
    private static Settings instance;
    private final FontPicker font;
    private final CheckBox update;
    private final CheckBox experiments;
    private VBox node;
    private HashMap<String, Object> map;
    private ObjectProperty<Font> fontProperty;

    public Settings() {
        ConfigManager.load();
        this.map = ConfigManager.getMap();
        this.node = new VBox(10.0);
        this.node.setPrefWidth(300.0);
        Font f = this.getFont();
        this.fontProperty = new SimpleObjectProperty<Font>(f);
        this.font = new FontPicker();
        this.font.setValue(f);
        HBox fontBox = new HBox();
        fontBox.setAlignment(Pos.CENTER);
        Label l = new Label("Font: ");
        fontBox.getChildren().addAll((Node[])new Node[]{l, this.font});
        this.node.getChildren().add(fontBox);
        this.update = new CheckBox();
        this.update.setSelected(this.isCheckingUpdate());
        HBox updateBox = new HBox();
        updateBox.setAlignment(Pos.CENTER);
        l = new Label("Check updates: ");
        updateBox.getChildren().addAll((Node[])new Node[]{l, this.update});
        this.node.getChildren().add(updateBox);
        this.experiments = new CheckBox();
        this.experiments.setSelected(this.isExperimental());
        HBox experimentsBox = new HBox();
        experimentsBox.setAlignment(Pos.CENTER);
        l = new Label("Enable experiments: ");
        experimentsBox.getChildren().addAll((Node[])new Node[]{l, this.experiments});
        this.node.getChildren().add(experimentsBox);
    }

    public static Settings getInstance() {
        if (instance == null) {
            instance = new Settings();
        }
        return instance;
    }

    public void show() {
        Dialog dialog = new Dialog();
        dialog.setTitle("Settings");
        dialog.setHeaderText(null);
        dialog.getDialogPane().getStylesheets().add(this.getClass().getResource("/style.css").toExternalForm());
        ButtonType okButton = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((ButtonType[])new ButtonType[]{okButton});
        dialog.getDialogPane().setContent(this.node);
        dialog.showAndWait();
        this.setFont((Font)this.font.getValue());
        this.setCheckingUpdate(this.update.isSelected());
        this.setExperimental(this.experiments.isSelected());
        ConfigManager.save();
    }

    public Font getFont() {
        SerializableFont font = (SerializableFont)this.map.get("font");
        return font != null ? font.getFont() : Font.font("Consolas");
    }

    public void setFont(Font f) {
        this.fontProperty.setValue(f);
        this.map.put("font", new SerializableFont(f));
    }

    public ObjectProperty<Font> fontProperty() {
        return this.fontProperty;
    }

    public String getLastPath() {
        return (String)this.map.get("last_path");
    }

    public void setLastPath(String p) {
        this.map.put("last_path", p);
        ConfigManager.save();
    }

    public boolean isCheckingUpdate() {
        return !this.map.containsKey("update_check") || (Boolean)this.map.get("update_check") != false;
    }

    public void setCheckingUpdate(boolean value) {
        this.map.put("update_check", value);
    }

    public boolean isExperimental() {
        return this.map.containsKey("enable_experiments") && (Boolean)this.map.get("enable_experiments") != false;
    }

    public void setExperimental(boolean value) {
        this.map.put("enable_experiments", value);
    }
}

