/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem.ui;

import java.util.Optional;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;

public class SegmentCreator {
    private static final double THICKNESS = 20.0;
    private static final double LENGTH = 100.0;
    private static final double OFFSET_X = 30.0;
    private static final double OFFSET_Y = 20.0;
    private static Segment[] segments = new Segment[8];

    public static String create() {
        for (Segment segment : segments) {
            segment.set = false;
        }
        Dialog<String> dialog = new Dialog<String>();
        dialog.setTitle("Pixel creator");
        dialog.setHeaderText(null);
        dialog.getDialogPane().getStylesheets().add(SegmentCreator.class.getResource("/style.css").toExternalForm());
        ButtonType okButton = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((ButtonType[])new ButtonType[]{okButton, ButtonType.CANCEL});
        VBox box = new VBox();
        Canvas canvas = new Canvas(200.0, 250.0);
        box.getChildren().add(canvas);
        for (Segment segment : segments) {
            segment.render(canvas.getGraphicsContext2D());
        }
        Label l = new Label(SegmentCreator.constructByte());
        canvas.setOnMouseClicked(event -> {
            for (Segment segment : segments) {
                if (!segment.contains(event.getX(), event.getY())) continue;
                segment.set = !segment.set;
                break;
            }
            canvas.getGraphicsContext2D().clearRect(0.0, 0.0, 150.0, 250.0);
            for (Segment segment1 : segments) {
                segment1.render(canvas.getGraphicsContext2D());
            }
            l.setText(SegmentCreator.constructByte());
        });
        box.getChildren().add(l);
        dialog.getDialogPane().setContent(box);
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == okButton) {
                return SegmentCreator.constructByte();
            }
            return "";
        });
        Optional result = dialog.showAndWait();
        return result.isPresent() ? (String)result.get() : "";
    }

    private static String constructByte() {
        StringBuilder sb = new StringBuilder("");
        for (int i = 7; i >= 0; --i) {
            sb.append(segments[i].set ? "1" : "0");
        }
        sb.append("b");
        return sb.toString();
    }

    static {
        SegmentCreator.segments[0] = new Segment(10.0, 0.0, SegmentType.HORIZONTAL, "a");
        SegmentCreator.segments[1] = new Segment(100.0, 10.0, SegmentType.VERTICAL, "b");
        SegmentCreator.segments[2] = new Segment(100.0, 110.0, SegmentType.VERTICAL, "c");
        SegmentCreator.segments[3] = new Segment(10.0, 200.0, SegmentType.HORIZONTAL, "d");
        SegmentCreator.segments[4] = new Segment(0.0, 110.0, SegmentType.VERTICAL, "e");
        SegmentCreator.segments[5] = new Segment(0.0, 10.0, SegmentType.VERTICAL, "f");
        SegmentCreator.segments[6] = new Segment(10.0, 100.0, SegmentType.HORIZONTAL, "g");
        SegmentCreator.segments[7] = new Segment(105.0, 205.0, SegmentType.SQUARE, "P");
    }

    private static class Segment {
        private final String name;
        private double x;
        private double y;
        private SegmentType type;
        private boolean set = false;

        Segment(double x, double y, SegmentType type, String name) {
            this.x = x + 30.0;
            this.y = y + 20.0;
            this.type = type;
            this.name = name;
        }

        void render(GraphicsContext c) {
            c.setLineWidth(2.0);
            c.setStroke(Color.GREEN);
            c.setFill(Color.GREEN);
            switch (this.type) {
                case HORIZONTAL: {
                    c.beginPath();
                    c.moveTo(this.x, this.y + 10.0);
                    c.lineTo(this.x + 10.0, this.y);
                    c.lineTo(this.x + 100.0 - 10.0, this.y);
                    c.lineTo(this.x + 100.0, this.y + 10.0);
                    c.lineTo(this.x + 100.0 - 10.0, this.y + 20.0);
                    c.lineTo(this.x + 10.0, this.y + 20.0);
                    c.lineTo(this.x, this.y + 10.0);
                    c.closePath();
                    if (this.set) {
                        c.fill();
                    }
                    c.stroke();
                    c.setFill(Color.WHITE);
                    c.fillText(this.name, this.x + 50.0, this.y + 13.333333333333334);
                    break;
                }
                case VERTICAL: {
                    c.beginPath();
                    c.moveTo(this.x + 10.0, this.y);
                    c.lineTo(this.x, this.y + 10.0);
                    c.lineTo(this.x, this.y + 100.0 - 10.0);
                    c.lineTo(this.x + 10.0, this.y + 100.0);
                    c.lineTo(this.x + 20.0, this.y + 100.0 - 10.0);
                    c.lineTo(this.x + 20.0, this.y + 10.0);
                    c.lineTo(this.x + 10.0, this.y);
                    c.closePath();
                    if (this.set) {
                        c.fill();
                    }
                    c.stroke();
                    c.setFill(Color.WHITE);
                    c.fillText(this.name, this.x + 6.666666666666667, this.y + 50.0);
                    break;
                }
                case SQUARE: {
                    c.beginPath();
                    c.moveTo(this.x + 10.0, this.y);
                    c.lineTo(this.x, this.y + 10.0);
                    c.lineTo(this.x, this.y + 10.0);
                    c.lineTo(this.x + 10.0, this.y + 20.0);
                    c.lineTo(this.x + 20.0, this.y + 10.0);
                    c.lineTo(this.x + 20.0, this.y + 10.0);
                    c.lineTo(this.x + 10.0, this.y);
                    c.closePath();
                    if (this.set) {
                        c.fill();
                    }
                    c.stroke();
                    c.setFill(Color.WHITE);
                    c.fillText(this.name, this.x + 6.666666666666667, this.y + 15.384615384615383);
                }
            }
        }

        boolean contains(double x, double y) {
            switch (this.type) {
                case HORIZONTAL: {
                    return this.x < x && this.y < y && this.x + 100.0 > x && this.y + 20.0 > y;
                }
                case VERTICAL: {
                    return this.x < x && this.y < y && this.x + 20.0 > x && this.y + 100.0 > y;
                }
                case SQUARE: {
                    return this.x < x && this.y < y && this.x + 20.0 > x && this.y + 20.0 > y;
                }
            }
            return false;
        }
    }

    static enum SegmentType {
        HORIZONTAL,
        VERTICAL,
        SQUARE;

    }
}

