/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem.ui;

import com.stirante.asem.Main;
import com.stirante.asem.ui.SegmentCreator;
import java.io.IOException;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;

public class ReplaceDialog {
    @FXML
    public TextField findField;
    @FXML
    public TextField replaceField;
    @FXML
    public Label status;
    private VBox node;
    private Main app;

    public ReplaceDialog(Main app) {
        this.app = app;
        FXMLLoader loader = new FXMLLoader(ReplaceDialog.class.getResource("/ReplaceDialog.fxml"));
        loader.setController(this);
        try {
            this.node = (VBox)loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void show(String initialText) {
        if (initialText != null) {
            this.findField.setText(initialText);
        }
        Dialog dialog = new Dialog();
        dialog.setTitle("Replace");
        dialog.setHeaderText(null);
        dialog.getDialogPane().getStylesheets().add(SegmentCreator.class.getResource("/style.css").toExternalForm());
        ButtonType replaceButton = new ButtonType("Replace", ButtonBar.ButtonData.OTHER);
        dialog.getDialogPane().getButtonTypes().addAll((ButtonType[])new ButtonType[]{replaceButton, ButtonType.CANCEL});
        dialog.getDialogPane().lookupButton(replaceButton).addEventFilter(ActionEvent.ACTION, event -> {
            event.consume();
            if (!this.app.hasOpenTab()) {
                return;
            }
            if (this.findField.getText().isEmpty() || this.replaceField.getText().isEmpty()) {
                return;
            }
            this.status.setText(this.app.getOpenTab().replace(this.findField.getText(), this.replaceField.getText()));
        });
        dialog.getDialogPane().setContent(this.node);
        dialog.show();
        if (initialText != null) {
            return;
        }
        if (!this.app.hasOpenTab()) {
            return;
        }
        if (this.findField.getText().isEmpty()) {
            return;
        }
        this.status.setText(this.app.getOpenTab().find(this.findField.getText()));
    }
}

