/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem.ui;

import java.util.Optional;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;

public class LcdCreator {
    private static final double SIZE = 20.0;
    private static final double PADDING = 5.0;
    private static final double OFFSET_X = 30.0;
    private static final double OFFSET_Y = 20.0;
    private static Pixel[][] pixels = new Pixel[8][5];

    public static String create() {
        Pixel[][] pixelArray = pixels;
        int n = pixelArray.length;
        for (int i = 0; i < n; ++i) {
            Pixel[] pixels1;
            for (Pixel pixel : pixels1 = pixelArray[i]) {
                pixel.set = false;
            }
        }
        Dialog<String> dialog = new Dialog<String>();
        dialog.setTitle("Pixel creator");
        dialog.setHeaderText(null);
        dialog.getDialogPane().getStylesheets().add(LcdCreator.class.getResource("/style.css").toExternalForm());
        ButtonType okButton = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((ButtonType[])new ButtonType[]{okButton, ButtonType.CANCEL});
        VBox box = new VBox();
        Canvas canvas = new Canvas(200.0, 250.0);
        box.getChildren().add(canvas);
        Pixel[] pixelArray2 = pixels;
        int n2 = pixelArray2.length;
        for (int i = 0; i < n2; ++i) {
            Pixel pixels1;
            for (Pixel pixel : pixels1 = pixelArray2[i]) {
                pixel.render(canvas.getGraphicsContext2D());
            }
        }
        canvas.setOnMouseClicked(event -> {
            Pixel[] pixels1;
            int n;
            Pixel[][] pixelArray = pixels;
            int n2 = pixelArray.length;
            block0: for (n = 0; n < n2; ++n) {
                for (Pixel pixel : pixels1 = pixelArray[n]) {
                    if (!pixel.contains(event.getX(), event.getY())) continue;
                    pixel.set = !pixel.set;
                    continue block0;
                }
            }
            pixelArray = pixels;
            n2 = pixelArray.length;
            for (n = 0; n < n2; ++n) {
                for (Pixel pixel : pixels1 = pixelArray[n]) {
                    pixel.render(canvas.getGraphicsContext2D());
                }
            }
        });
        dialog.getDialogPane().setContent(box);
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == okButton) {
                return LcdCreator.constructDb();
            }
            return "";
        });
        Optional result = dialog.showAndWait();
        return result.isPresent() ? (String)result.get() : "";
    }

    private static String constructDb() {
        StringBuilder sb = new StringBuilder("name:\n");
        for (int y = 0; y < 8; ++y) {
            sb.append("\tDB\t000");
            for (int x = 0; x < 5; ++x) {
                sb.append(pixels[y][x].set ? "1" : "0");
            }
            sb.append("b\n");
        }
        return sb.toString();
    }

    static {
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 5; ++x) {
                LcdCreator.pixels[y][x] = new Pixel((double)x * 25.0, (double)y * 25.0);
            }
        }
    }

    private static class Pixel {
        private double x;
        private double y;
        private boolean set = false;

        Pixel(double x, double y) {
            this.x = x + 30.0;
            this.y = y + 20.0;
        }

        void render(GraphicsContext c) {
            c.clearRect(this.x, this.y, 20.0, 20.0);
            c.setLineWidth(2.0);
            c.setStroke(Color.GREEN);
            c.setFill(Color.GREEN);
            if (this.set) {
                c.fillRect(this.x, this.y, 20.0, 20.0);
            }
            c.strokeRect(this.x, this.y, 20.0, 20.0);
        }

        boolean contains(double x, double y) {
            return this.x < x && this.y < y && this.x + 20.0 > x && this.y + 20.0 > y;
        }
    }
}

