/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem.ui;

import com.stirante.asem.Main;
import com.stirante.asem.ui.SegmentCreator;
import java.io.IOException;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;

public class FindDialog {
    @FXML
    public TextField findField;
    @FXML
    public Label status;
    private VBox node;
    private Main app;

    public FindDialog(Main app) {
        this.app = app;
        FXMLLoader loader = new FXMLLoader(FindDialog.class.getResource("/FindDialog.fxml"));
        loader.setController(this);
        try {
            this.node = (VBox)loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void show(String initialText) {
        if (initialText != null) {
            this.findField.setText(initialText);
        }
        Dialog dialog = new Dialog();
        dialog.setTitle("Find");
        dialog.setHeaderText(null);
        dialog.getDialogPane().getStylesheets().add(SegmentCreator.class.getResource("/style.css").toExternalForm());
        ButtonType findButton = new ButtonType("Find", ButtonBar.ButtonData.OTHER);
        dialog.getDialogPane().getButtonTypes().addAll((ButtonType[])new ButtonType[]{findButton, ButtonType.CANCEL});
        dialog.getDialogPane().lookupButton(findButton).addEventFilter(ActionEvent.ACTION, event -> {
            event.consume();
            this.onAction();
        });
        dialog.getDialogPane().setContent(this.node);
        this.findField.requestFocus();
        dialog.show();
    }

    public void onAction() {
        if (!this.app.hasOpenTab()) {
            return;
        }
        if (this.findField.getText().isEmpty()) {
            return;
        }
        this.status.setText(this.app.getOpenTab().find(this.findField.getText()));
    }
}

