/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem.ui;

import com.stirante.asem.Constants;
import com.stirante.asem.Main;
import com.stirante.asem.syntax.SyntaxAnalyzer;
import com.stirante.asem.syntax.SyntaxHighlighter;
import com.stirante.asem.syntax.code.FieldElement;
import com.stirante.asem.syntax.code.RoutineElement;
import com.stirante.asem.ui.AutocompletionPopup;
import com.stirante.asem.ui.Settings;
import com.stirante.asem.ui.tooltip.TooltipPopup;
import com.stirante.asem.utils.AsyncTask;
import com.stirante.asem.utils.DelayedTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import java.util.regex.Matcher;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.fxmisc.richtext.event.MouseOverTextEvent;
import org.fxmisc.richtext.model.TwoDimensional;

public class CodeView
extends Tab {
    private static int newCounter = 1;
    private final TooltipPopup tooltipPopup;
    @FXML
    public StackPane content;
    private ContextMenu context;
    private MenuItem copyItem;
    private File file;
    private CodeArea codeArea;
    private boolean changed = false;
    private String original = "";
    private SyntaxAnalyzer.AnalysisResult syntaxAnalysis;
    private AutocompletionPopup autocompletionPopup;
    private SyntaxHighlighter highlighter;
    private DelayedTask elementHighlightTask;
    private DelayedTask syntaxHighlightTask;

    public CodeView(Main app, File f) {
        this.file = f;
        this.setOnCloseRequest(event -> this.onClose());
        this.codeArea = new CodeArea();
        this.highlighter = new SyntaxHighlighter(this, this.codeArea);
        this.autocompletionPopup = new AutocompletionPopup(this, this.codeArea);
        this.tooltipPopup = new TooltipPopup(this, this.codeArea);
        this.elementHighlightTask = new DelayedTask(500L);
        this.syntaxHighlightTask = new DelayedTask(300L);
        this.checkChanges();
        this.initMouse();
        this.initKeyboard();
        this.codeArea.setStyle("-fx-font-family: " + Settings.getInstance().getFont().getFamily() + ";-fx-font-size: " + Settings.getInstance().getFont().getSize() + ";");
        Settings.getInstance().fontProperty().addListener((observable, oldValue, newValue) -> this.codeArea.setStyle("-fx-font-family: " + newValue.getFamily() + ";-fx-font-size: " + newValue.getSize() + ";"));
        this.codeArea.setParagraphGraphicFactory(LineNumberFactory.get(this.codeArea));
        this.codeArea.textProperty().addListener((observable, oldValue, newValue) -> {
            this.checkChanges();
            this.computeHighlighting();
        });
        this.loadFile();
        FXMLLoader loader = new FXMLLoader(CodeView.class.getResource("/Tab.fxml"));
        loader.setController(this);
        try {
            AnchorPane pane = (AnchorPane)loader.load();
            VirtualizedScrollPane<CodeArea> e = new VirtualizedScrollPane<CodeArea>(this.codeArea);
            this.content.getChildren().add(e);
            this.setContent(pane);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.file != null) {
            this.setText(this.file.getName());
        } else {
            this.setText("New file " + newCounter + "*");
            ++newCounter;
        }
    }

    private static String getTime() {
        return SimpleDateFormat.getTimeInstance().format(new Date(System.currentTimeMillis()));
    }

    private void computeHighlighting() {
        this.syntaxHighlightTask.start(() -> this.highlighter.computeHighlighting());
    }

    private void initKeyboard() {
        this.codeArea.setOnKeyPressed(event -> {
            if (event.isControlDown() && event.getCode() == KeyCode.SPACE) {
                this.autocompletionPopup.triggerAutocompletion();
                event.consume();
            } else if (event.isControlDown() && event.getCode() == KeyCode.SLASH) {
                this.triggerComment();
                event.consume();
            } else if (event.getCode() == KeyCode.CONTROL && Settings.getInstance().isExperimental()) {
                this.highlighter.setShowClickables(true);
                this.computeHighlighting();
            } else if (event.getCode() == KeyCode.ENTER) {
                int end;
                int l = this.codeArea.offsetToPosition(this.codeArea.getCaretPosition(), TwoDimensional.Bias.Forward).getMajor() - 1;
                int start = this.codeArea.position(l, 0).toOffset();
                boolean diff = false;
                try {
                    end = this.codeArea.position(l + 1, 0).toOffset() - 1;
                }
                catch (Exception e) {
                    end = this.codeArea.getLength();
                }
                String line = this.codeArea.getText().substring(start, end);
                Matcher matcher = Constants.WHITESPACE.matcher(line);
                if (matcher.matches()) {
                    String str = matcher.group(1);
                    this.codeArea.insertText(this.codeArea.getCaretPosition(), str);
                }
            }
        });
        this.codeArea.setOnKeyReleased(event -> {
            if (event.getCode() == KeyCode.CONTROL && Settings.getInstance().isExperimental()) {
                this.highlighter.setShowClickables(false);
                this.computeHighlighting();
            }
        });
    }

    private void triggerComment() {
        int start;
        ArrayList<Integer> lines = new ArrayList<Integer>();
        boolean wasSelected = false;
        int end = 0;
        if (this.codeArea.selectedTextProperty().getValue().isEmpty()) {
            lines.add(this.codeArea.offsetToPosition(this.codeArea.getCaretPosition(), TwoDimensional.Bias.Forward).getMajor());
            start = this.codeArea.getCaretPosition();
        } else {
            wasSelected = true;
            start = this.codeArea.selectionProperty().getValue().getStart();
            end = this.codeArea.selectionProperty().getValue().getEnd();
            int startLine = this.codeArea.offsetToPosition(start, TwoDimensional.Bias.Forward).getMajor();
            int endLine = this.codeArea.offsetToPosition(end, TwoDimensional.Bias.Forward).getMajor();
            for (int i = startLine; i <= endLine; ++i) {
                lines.add(i);
            }
        }
        this.highlighter.setPause(true);
        int[] diff = new int[]{0};
        int[] first = new int[]{0};
        lines.forEach(integer -> {
            int i = this.commentLine((int)integer);
            diff[0] = diff[0] + i;
            if (first[0] == 0) {
                first[0] = i;
            }
        });
        this.highlighter.setPause(false);
        this.checkChanges();
        this.computeHighlighting();
        if (wasSelected) {
            this.codeArea.selectRange(start + first[0], end += diff[0]);
        } else {
            this.codeArea.moveTo(start += diff[0]);
            this.codeArea.requestFollowCaret();
        }
    }

    private int commentLine(int l) {
        int end;
        int start = this.codeArea.position(l, 0).toOffset();
        int diff = 0;
        try {
            end = this.codeArea.position(l + 1, 0).toOffset() - 1;
        }
        catch (Exception e) {
            end = this.codeArea.getLength();
        }
        String line = this.codeArea.getText().substring(start, end);
        if (Constants.IS_COMMENTED.matcher(line).matches()) {
            line = line.replaceFirst(";", "");
            diff = -1;
        } else {
            Matcher matcher = Constants.TO_COMMENT.matcher(line);
            if (matcher.find()) {
                line = matcher.group(1) + ";" + matcher.group(2);
                diff = 1;
            }
        }
        this.codeArea.replaceText(start, end, line);
        return diff;
    }

    private void loadFile() {
        if (this.file != null) {
            new AsyncTask<Void, Void, String>(){

                public String doInBackground(Void[] params) {
                    try {
                        return new String(Files.readAllBytes(CodeView.this.file.toPath()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return "";
                    }
                }

                @Override
                public void onPostExecute(String result) {
                    CodeView.this.original = result;
                    CodeView.this.codeArea.replaceText(0, 0, result);
                    CodeView.this.codeArea.moveTo(0);
                    CodeView.this.codeArea.requestFollowCaret();
                    CodeView.this.codeArea.getUndoManager().forgetHistory();
                    CodeView.this.codeArea.getUndoManager().mark();
                    CodeView.this.checkChanges();
                }
            }.execute(new Void[0]);
        } else {
            this.changed = true;
        }
    }

    private void initMouse() {
        this.context = new ContextMenu();
        this.copyItem = new MenuItem("Copy");
        this.copyItem.setOnAction(e -> {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString(this.codeArea.getSelectedText());
            clipboard.setContent(content);
        });
        this.context.getItems().addAll((MenuItem[])new MenuItem[]{this.copyItem});
        this.codeArea.setOnContextMenuRequested(event -> {
            this.context.show(this.codeArea, event.getScreenX(), event.getScreenY());
            String selectedText = this.codeArea.getSelectedText();
            this.copyItem.setDisable(selectedText == null || selectedText.isEmpty());
        });
        this.codeArea.setOnMouseClicked(event -> {
            this.context.hide();
            this.autocompletionPopup.hide();
            if (event.isControlDown()) {
                this.triggerGoTo((MouseEvent)event);
            }
        });
        this.codeArea.setMouseOverTextDelay(Duration.ofMillis(700L));
        this.codeArea.addEventHandler(MouseOverTextEvent.MOUSE_OVER_TEXT_BEGIN, this.tooltipPopup::triggerTooltip);
        this.codeArea.addEventHandler(MouseOverTextEvent.MOUSE_OVER_TEXT_END, e -> this.tooltipPopup.hide());
        this.codeArea.caretPositionProperty().addListener((observable, oldValue, newValue) -> {
            if (Settings.getInstance().isExperimental()) {
                this.elementHighlightTask.start(() -> {
                    String wordAt = this.getWordAt((int)newValue);
                    String old = this.highlighter.getHighlightWord();
                    for (RoutineElement routineElement : this.syntaxAnalysis.getRoutines()) {
                        if (!routineElement.getName().equals(wordAt)) continue;
                        this.highlighter.setHighlightWord(wordAt);
                        this.computeHighlighting();
                        return;
                    }
                    for (FieldElement fieldElement : this.syntaxAnalysis.getFields()) {
                        if (!fieldElement.getName().equals(wordAt)) continue;
                        this.highlighter.setHighlightWord(wordAt);
                        this.computeHighlighting();
                        return;
                    }
                    this.highlighter.setHighlightWord("");
                    if (!old.isEmpty()) {
                        this.computeHighlighting();
                    }
                });
            }
        });
    }

    private void triggerGoTo(MouseEvent event) {
        CharacterHit hit = this.codeArea.hit(event.getX(), event.getY());
        int index = hit.getInsertionIndex();
        String s = this.getWordAt(index);
        for (FieldElement field : this.syntaxAnalysis.getFields()) {
            if (!field.matches(s, 0, 0)) continue;
            this.codeArea.moveTo(field.getDefinitionStart());
            this.codeArea.requestFollowCaret();
            return;
        }
        for (RoutineElement routine : this.syntaxAnalysis.getRoutines()) {
            if (!routine.matches(s, 0, 0)) continue;
            this.codeArea.moveTo(routine.getDefinitionStart());
            this.codeArea.requestFollowCaret();
            return;
        }
    }

    public String getWordAt(int index) {
        int start = index;
        int end = index;
        Matcher matcher = Constants.WORD.matcher(this.codeArea.getText());
        while (matcher.find()) {
            if (matcher.start() > index || matcher.end() < index) continue;
            start = matcher.start();
            end = matcher.end();
        }
        return this.codeArea.getText().substring(start, end);
    }

    private void checkChanges() {
        this.syntaxAnalysis = SyntaxAnalyzer.analyze(this.codeArea.getText());
        if (this.autocompletionPopup.isAutocompletion()) {
            this.autocompletionPopup.onChanges();
        }
        if (this.file == null) {
            return;
        }
        boolean old = this.changed;
        boolean bl = this.changed = !this.codeArea.getText().replaceAll("\n", "\r\n").equals(this.original);
        if (this.changed && !old) {
            this.setText(this.file.getName() + "*");
        } else if (!this.changed && old) {
            this.setText(this.file.getName());
        }
    }

    public boolean save() {
        if (this.file == null) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Save file");
            String path = Settings.getInstance().getLastPath();
            if (path != null && !path.isEmpty()) {
                fileChooser.setInitialDirectory(new File(path));
            }
            fileChooser.getExtensionFilters().addAll((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("ASM file", "*.asm"), new FileChooser.ExtensionFilter("All files", "*.*")});
            File file = fileChooser.showSaveDialog(Main.getStage());
            if (file != null) {
                Settings.getInstance().setLastPath(file.getParentFile().getAbsolutePath());
                this.file = file;
            } else {
                return false;
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(this.file);
            String text = this.codeArea.getText().replaceAll("\n", "\r\n");
            fos.write(text.getBytes());
            fos.flush();
            fos.close();
            this.original = text;
            this.changed = false;
            this.setText(this.file.getName());
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void onClose() {
        if (this.changed) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            alert.setTitle("Unsaved changes in tab " + this.getText().substring(0, this.getText().length() - 1));
            alert.setHeaderText(null);
            alert.setContentText("Do you want to save it?");
            alert.getDialogPane().getStylesheets().add(this.getClass().getResource("/style.css").toExternalForm());
            ButtonType yes = new ButtonType("Yes", ButtonBar.ButtonData.YES);
            ButtonType no = new ButtonType("No", ButtonBar.ButtonData.NO);
            alert.getButtonTypes().setAll((ButtonType[])new ButtonType[]{yes, no});
            Optional result = alert.showAndWait();
            if (result.isPresent() && result.get() == yes) {
                this.save();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeView codeView = (CodeView)o;
        return this.file != null && this.file.equals(codeView.file);
    }

    public int hashCode() {
        if (this.file == null) {
            return super.hashCode();
        }
        return this.file.hashCode();
    }

    public String compile() {
        ProcessBuilder pb = new ProcessBuilder(new File("bin/asemw.exe").getAbsolutePath(), this.file.getAbsolutePath());
        pb.directory(this.file.getParentFile());
        try {
            String line;
            Process process = pb.start();
            int code = process.waitFor();
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(CodeView.getTime()).append("] Compiling ").append(this.file.getAbsolutePath()).append('\n');
            while ((line = br.readLine()) != null) {
                sb.append(line).append('\n');
            }
            br.close();
            sb.append("\n[").append(CodeView.getTime()).append("] Compiler terminated with code ").append(code);
            return sb.toString();
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return "Failed to run compiler!\n" + e.getMessage();
        }
    }

    public void undo() {
        this.codeArea.undo();
    }

    public void redo() {
        this.codeArea.redo();
    }

    public void insert(String str) {
        this.codeArea.insertText(this.codeArea.getCaretPosition(), str);
    }

    public String run() {
        File hex = new File(this.file.getParentFile(), this.file.getName().substring(0, this.file.getName().lastIndexOf(46)) + ".hex");
        if (!hex.exists()) {
            return "You need to compile file first!";
        }
        ProcessBuilder pb = new ProcessBuilder(new File("bin/DSM-51_Any_CPU.exe").getAbsolutePath(), hex.getAbsolutePath());
        pb.directory(this.file.getParentFile());
        try {
            pb.start();
            return "Simulator started with file " + hex.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Failed to run emulator!\n" + e.getMessage();
        }
    }

    public String sendHex() {
        File hex = new File(this.file.getParentFile(), this.file.getName().substring(0, this.file.getName().lastIndexOf(46)) + ".hex");
        if (!hex.exists()) {
            return "You need to compile file first!";
        }
        String ini = "nastawy programu Hex_Sender\r\n" + hex.getParentFile().getAbsolutePath() + "\\\r\n1\r\n" + hex.getName() + "\r\n";
        File iniFile = new File("bin/hex_sender.ini");
        try {
            iniFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(iniFile);
            fos.write(ini.getBytes());
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Failed to set config file!\n" + e.getMessage();
        }
        File file = new File("bin/hex_sender.exe");
        ProcessBuilder pb = new ProcessBuilder(file.getAbsolutePath());
        pb.directory(file.getParentFile());
        try {
            pb.start();
            return "Hex sender started with file " + hex.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Failed to run hex sender!\n" + e.getMessage();
        }
    }

    void goToLine(int line) {
        this.codeArea.moveTo(this.codeArea.position(line - 1, 0).toOffset());
        this.codeArea.requestFollowCaret();
    }

    public String find(String text) {
        int start = this.codeArea.selectedTextProperty().getValue().isEmpty() ? this.codeArea.getCaretPosition() : this.codeArea.selectionProperty().getValue().getEnd();
        int i = this.codeArea.getText().toLowerCase().indexOf(text.toLowerCase(), start);
        if (i == -1) {
            i = this.codeArea.getText().toLowerCase().indexOf(text.toLowerCase());
            if (i == -1) {
                return "Not found!";
            }
            this.codeArea.selectRange(i, text.length() + i);
            this.codeArea.requestFollowCaret();
            return "";
        }
        this.codeArea.selectRange(i, text.length() + i);
        this.codeArea.requestFollowCaret();
        return "";
    }

    public String getSelectedText() {
        return this.codeArea.getSelectedText();
    }

    public String replace(String text, String replacement) {
        if (this.getSelectedText().isEmpty() || !this.getSelectedText().equalsIgnoreCase(text)) {
            return "Not found!";
        }
        this.codeArea.replaceText(this.codeArea.selectionProperty().getValue().getStart(), this.codeArea.selectionProperty().getValue().getEnd(), replacement);
        this.find(text);
        return "";
    }

    public SyntaxAnalyzer.AnalysisResult getSyntaxAnalysis() {
        return this.syntaxAnalysis;
    }
}

