/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;

public class ByteCreator {
    @FXML
    public TextArea description;
    @FXML
    public TextField bit7;
    @FXML
    public TextField bit6;
    @FXML
    public TextField bit5;
    @FXML
    public TextField bit4;
    @FXML
    public TextField bit3;
    @FXML
    public TextField bit2;
    @FXML
    public TextField bit1;
    @FXML
    public TextField bit0;
    private ArrayList<String> descriptions;
    private TextField[] bits;
    private VBox node;

    public ByteCreator() {
        FXMLLoader loader = new FXMLLoader(ByteCreator.class.getResource("/ByteCreator.fxml"));
        loader.setController(this);
        try {
            this.node = (VBox)loader.load();
            this.bits = new TextField[]{this.bit0, this.bit1, this.bit2, this.bit3, this.bit4, this.bit5, this.bit6, this.bit7};
            this.reset();
            for (int i = 0; i < 8; ++i) {
                this.setupField(this.bits[i], i);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setupField(TextField f, int index) {
        f.setOnMouseClicked(event -> {
            f.selectAll();
            this.description.setText(this.descriptions.get(index));
        });
        f.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.length() > 1) {
                f.setText((String)oldValue);
            }
            if (newValue.length() == 1 && newValue.charAt(0) != '0' && newValue.charAt(0) != '1') {
                f.setText((String)oldValue);
            }
        });
    }

    public void reset() {
        this.description.setText("");
        for (TextField bit : this.bits) {
            bit.setText("0");
        }
    }

    public String create(String name, ArrayList<String> descriptions) {
        this.descriptions = descriptions;
        this.reset();
        Dialog<String> dialog = new Dialog<String>();
        dialog.setTitle("Byte creator - " + name);
        dialog.setHeaderText(null);
        dialog.getDialogPane().getStylesheets().add(this.getClass().getResource("/style.css").toExternalForm());
        ButtonType okButton = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().addAll((ButtonType[])new ButtonType[]{okButton, ButtonType.CANCEL});
        dialog.getDialogPane().setContent(this.node);
        Platform.runLater(() -> {
            this.bit7.requestFocus();
            this.description.setText((String)descriptions.get(7));
        });
        dialog.setResultConverter(dialogButton -> {
            if (dialogButton == okButton) {
                return this.constructByte();
            }
            return "";
        });
        Optional result = dialog.showAndWait();
        return result.isPresent() ? (String)result.get() : "";
    }

    private String constructByte() {
        StringBuilder sb = new StringBuilder("#");
        for (int i = 7; i >= 0; --i) {
            TextField bit = this.bits[i];
            if (bit.getText().isEmpty()) {
                sb.append("0");
                continue;
            }
            sb.append(bit.getText());
        }
        sb.append("b");
        return sb.toString();
    }
}

