/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem.ui;

import com.stirante.asem.Constants;
import com.stirante.asem.syntax.code.FieldElement;
import com.stirante.asem.syntax.code.RoutineElement;
import com.stirante.asem.ui.CodeView;
import com.sun.javafx.collections.ObservableListWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.geometry.Bounds;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.KeyCode;
import javafx.stage.Popup;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.model.TwoDimensional;

public class AutocompletionPopup
extends Popup {
    private final ListView<String> list;
    private final CodeView view;
    private final CodeArea codeArea;
    ObservableListWrapper<String> items = new ObservableListWrapper(new ArrayList());
    private boolean autocomplete = false;
    private int autoIndex = 0;
    private boolean wasMnemonic = false;

    public AutocompletionPopup(CodeView view, CodeArea codeArea) {
        this.view = view;
        this.codeArea = codeArea;
        this.list = new ListView();
        this.list.setStyle("-fx-background-color: #2e2e2e;-fx-text-fill: #8a8a8a;-fx-border-color: white;-fx-padding: 5;");
        this.list.setMaxWidth(600.0);
        this.list.setMaxHeight(300.0);
        this.list.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.list.setItems(this.items);
        this.list.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                String item = (String)this.list.getSelectionModel().getSelectedItem();
                boolean wasCall = false;
                if (item.equalsIgnoreCase("lcall\t\t") || item.equalsIgnoreCase("sjmp\t\t") || item.equalsIgnoreCase("ljmp\t\t") || item.equalsIgnoreCase("acall\t\t") || item.equalsIgnoreCase("jz\t\t")) {
                    wasCall = true;
                }
                view.insert(item.substring(this.autoIndex));
                this.hide();
                if (this.wasMnemonic && !item.startsWith("ret")) {
                    this.triggerAutocompletion(wasCall);
                    this.wasMnemonic = false;
                }
            } else if (event.getCode() == KeyCode.ESCAPE) {
                this.hide();
            }
        });
        this.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.hide();
            }
        });
        this.getContent().add(this.list);
    }

    @Override
    public void hide() {
        super.hide();
        this.autocomplete = false;
    }

    public boolean isAutocompletion() {
        return this.autocomplete;
    }

    public boolean triggerAutocompletion() {
        return this.triggerAutocompletion(false);
    }

    private boolean triggerAutocompletion(boolean wasCall) {
        TwoDimensional.Position caret = this.codeArea.offsetToPosition(this.codeArea.getCaretPosition(), TwoDimensional.Bias.Forward);
        TwoDimensional.Position lineStart = this.codeArea.position(caret.getMajor(), 0);
        String line = this.codeArea.getText().substring(lineStart.toOffset(), caret.toOffset());
        boolean isMnemonic = Constants.MNEMONIC.matcher(line).matches();
        String s = this.view.getWordAt(this.codeArea.getCaretPosition());
        ArrayList<String> suggestions = new ArrayList<String>();
        if (isMnemonic) {
            this.wasMnemonic = true;
            boolean upperCase = Character.isUpperCase(s.charAt(0));
            String s1 = s.toUpperCase();
            for (String s2 : Constants.MNEMONIC_ARRAY) {
                if (!s2.startsWith(s1)) continue;
                String tabs = s2.toLowerCase().startsWith("ret") ? "" : "\t\t";
                suggestions.add(upperCase ? s2 + tabs : s2.toLowerCase() + tabs);
            }
        } else {
            if (!wasCall) {
                suggestions.addAll(this.view.getSyntaxAnalysis().getFields().stream().filter(field -> field.getName().startsWith(s)).map(FieldElement::getName).collect(Collectors.toList()));
            }
            suggestions.addAll(this.view.getSyntaxAnalysis().getRoutines().stream().filter(routine -> routine.getName().startsWith(s)).map(RoutineElement::getName).collect(Collectors.toList()));
        }
        if (suggestions.isEmpty()) {
            return false;
        }
        Optional<Bounds> invoke = this.codeArea.getCaretBounds();
        if (invoke.isPresent()) {
            Bounds b = invoke.get();
            this.autoIndex = s.length();
            this.setSuggestions(suggestions);
            this.autocomplete = true;
            this.show(this.codeArea, b.getMinX(), b.getMaxY());
            return true;
        }
        return false;
    }

    public void setSuggestions(ArrayList<String> list) {
        Collections.sort(list);
        this.items.clear();
        this.items.addAll((Collection<String>)list);
        this.list.getSelectionModel().select(0);
    }

    public void setIndex(int index) {
        this.autoIndex = index;
    }

    public void onChanges() {
        String s = this.view.getWordAt(this.codeArea.getCaretPosition());
        this.autoIndex = s.length();
        this.items.removeIf(str -> !str.toLowerCase().startsWith(s.toLowerCase()));
        if (this.items.isEmpty()) {
            this.hide();
        }
    }
}

