/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem.syntax.code;

import com.stirante.asem.syntax.code.CodeCollisionElement;
import com.stirante.asem.syntax.code.CodeElementType;
import com.stirante.asem.utils.TextRange;

public class ReservedAddressCollisionElement
extends CodeCollisionElement {
    private String name;
    private TextRange range;

    public ReservedAddressCollisionElement(int start, int end, int line, int address, String name) {
        super(-1, -1, -1, address);
        this.name = name;
        this.range = new TextRange(start, end, line);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getDefinitionStart() {
        return this.range.getStart();
    }

    @Override
    public int getDefinitionEnd() {
        return this.range.getEnd();
    }

    @Override
    public int getDefinitionLine() {
        return this.range.getLine();
    }

    @Override
    public CodeElementType getType() {
        return CodeElementType.WARNING;
    }

    @Override
    public boolean matches(String word, int index, int line) {
        return this.range.contains(index);
    }

    @Override
    public String getTooltipText(String word, int index, int line) {
        return "Collision address with " + this.name + "!";
    }
}

