/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem.syntax.code;

import com.stirante.asem.syntax.code.CodeElement;
import com.stirante.asem.syntax.code.CodeElementType;
import com.stirante.asem.ui.tooltip.TooltipContent;

public class FieldElement
implements CodeElement,
TooltipContent {
    private int start;
    private int end;
    private int line;
    private String name;
    private String type;
    private String value;
    private String comment;

    public FieldElement(int start, int end, int line, String name, String type, String value, String comment) {
        this.start = start;
        this.end = end;
        this.line = line;
        this.name = name;
        this.type = type;
        this.value = value;
        this.comment = comment;
    }

    public String getValue() {
        return this.value;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public int getDefinitionStart() {
        return this.start;
    }

    @Override
    public int getDefinitionEnd() {
        return this.end;
    }

    @Override
    public int getDefinitionLine() {
        return this.line;
    }

    public String getName() {
        return this.name;
    }

    public String getFieldType() {
        return this.type;
    }

    @Override
    public CodeElementType getType() {
        return CodeElementType.FIELD;
    }

    @Override
    public boolean matches(String word, int index, int line) {
        return word.equals(this.getName());
    }

    @Override
    public String getTooltipText(String word, int index, int line) {
        return "Name: " + this.getName() + "\nType: " + this.getFieldType() + "\nValue: " + this.getValue() + (this.getComment() != null && !this.getComment().isEmpty() ? "\n" + this.getComment() : "");
    }
}

