/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem.syntax.code;

import com.stirante.asem.syntax.code.CodeElement;
import com.stirante.asem.syntax.code.CodeElementType;
import com.stirante.asem.ui.tooltip.TooltipContent;
import com.stirante.asem.utils.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class CodeCollisionElement
implements CodeElement,
TooltipContent {
    private int address;
    private ArrayList<TextRange> ranges = new ArrayList();

    public CodeCollisionElement(int start, int end, int line, int address) {
        this.address = address;
        this.ranges.add(new TextRange(start, end, line));
    }

    public void addCollision(int start, int end, int line) {
        this.ranges.add(new TextRange(start, end, line));
    }

    public Collection<TextRange> getRanges() {
        return Collections.unmodifiableCollection(this.ranges);
    }

    @Override
    public int getDefinitionStart() {
        return -1;
    }

    @Override
    public int getDefinitionEnd() {
        return -1;
    }

    @Override
    public int getDefinitionLine() {
        return -1;
    }

    @Override
    public CodeElementType getType() {
        return CodeElementType.WARNING;
    }

    @Override
    public boolean matches(String word, int index, int line) {
        for (TextRange range : this.ranges) {
            if (!range.contains(index)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTooltipText(String word, int index, int line) {
        return "Collision address! (" + this.address + "d, " + Integer.toHexString(this.address) + "h)";
    }

    public int getAddress() {
        return this.address;
    }
}

