/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem.syntax;

import com.stirante.asem.syntax.code.CodeCollisionElement;
import com.stirante.asem.syntax.code.CodeErrorElement;
import com.stirante.asem.syntax.code.FieldElement;
import com.stirante.asem.syntax.code.ReservedAddressCollisionElement;
import com.stirante.asem.syntax.code.RoutineElement;
import com.stirante.asem.ui.CodeView;
import com.stirante.asem.ui.Settings;
import com.stirante.asem.utils.AsyncTask;
import com.stirante.asem.utils.BetterSpanBuilder;
import com.stirante.asem.utils.TextRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.model.StyleSpans;

public class SyntaxHighlighter {
    private static final String[] INSTRUCTIONS = new String[]{"PUSH", "POP", "MOV", "MOVX", "MOVC", "ADD", "ADDC", "SUBB", "INC", "DEC", "CLR", "CPL", "SETB", "SJMP", "AJMP", "LJMP", "ACALL", "LCALL", "RET", "RETI", "DJNZ", "CJNE", "JZ", "JNZ", "JC", "JNC", "JB", "JBC", "JNB", "ANL", "ORL", "XRL", "RL", "RLC", "RR", "RRC", "MUL", "DIV", "SWAP", "XCH", "XCHD", "DA", "NOP"};
    private static final String[] DIRECTIVES = new String[]{"DB", "HIGH", "LOW", "ORG", "USING", "EQU", "SET", "CALL", "JMP", "END", "DATA", "BIT"};
    private static final String[] ALIASES = new String[]{"SP", "DPL", "DPH", "PCON", "TCON", "TMOD", "TL0", "TL1", "TH0", "TH1", "SCON", "SBUF", "PCON", "IE", "IP", "PSW", "ACC", "P0\\.0", "P0\\.1", "P0\\.2", "P0\\.3", "P0\\.4", "P0\\.5", "P0\\.6", "P0\\.7", "P0", "P1\\.0", "P1\\.1", "P1\\.2", "P1\\.3", "P1\\.4", "P1\\.5", "P1\\.6", "P1\\.7", "P1", "P2\\.0", "P2\\.1", "P2\\.2", "P2\\.3", "P2\\.4", "P2\\.5", "P2\\.6", "P2\\.7", "P2", "P3\\.0", "P3\\.1", "P3\\.2", "P3\\.3", "P3\\.4", "P3\\.5", "P3\\.6", "P3\\.7", "P3", "ACC\\.0", "ACC\\.1", "ACC\\.2", "ACC\\.3", "ACC\\.4", "ACC\\.5", "ACC\\.6", "ACC\\.7", "B\\.0", "B\\.1", "B\\.2", "B\\.3", "B\\.4", "B\\.5", "B\\.6", "B\\.7", "AR0", "AR1", "AR2", "AR3", "AR4", "AR5", "AR6", "AR7", "IT0", "IE0", "IT1", "IE1", "TR0", "TF0", "TR1", "TF1", "RI", "TI", "RB8", "TB8", "REN", "SM2", "SM1", "SM0", "EX0", "ET0", "EX1", "ET1", "ES", "EA", "PT0", "PX1", "PT1", "PS", "P", "OV", "RS0", "RS1", "F0", "AC", "CY", "A", "AB", "B", "C", "R0", "R1", "R2", "R3", "R4", "R5", "R6", "R7", "@R0", "@R1", "@DPTR", "DPTR", "@A\\+DPTR", "@A\\+PC"};
    private static final String INSTRUCTION_PATTERN = "\\b(" + String.join((CharSequence)"|", INSTRUCTIONS) + ")\\b";
    private static final String DIRECTIVES_PATTERN = "\\s(" + String.join((CharSequence)"|", DIRECTIVES) + ")\\b";
    private static final String ALIASES_PATTERN = "\\b(" + String.join((CharSequence)"|", ALIASES) + ")\\b";
    private static final String NUMBER_PATTERN = "\\W#?([01]+B|[0-9ABCDEF]+H|[0-9]+D?)\\b";
    private static final String COMMENT_PATTERN = ";.*";
    private static final String DOLLAR_PATTERN = "\\$.+";
    private static final Pattern PATTERN = Pattern.compile("(?<COMMENT>;.*)|(?<INSTRUCTION>" + INSTRUCTION_PATTERN + ")|(?<DIRECTIVE>" + DIRECTIVES_PATTERN + ")|(?<ALIAS>" + ALIASES_PATTERN + ")|(?<NUMBER>" + "\\W#?([01]+B|[0-9ABCDEF]+H|[0-9]+D?)\\b" + ")|(?<DOLLAR>" + "\\$.+" + ")");
    private final CodeView codeView;
    private final CodeArea text;
    private AsyncTask<Void, Void, Object> task;
    private AtomicBoolean pause = new AtomicBoolean(false);
    private AtomicBoolean showClickables = new AtomicBoolean(false);
    private String highlightWord = "";

    public SyntaxHighlighter(CodeView codeView, CodeArea codeArea) {
        this.codeView = codeView;
        this.text = codeArea;
    }

    public String getHighlightWord() {
        return this.highlightWord;
    }

    public void setHighlightWord(String highlightWord) {
        this.highlightWord = highlightWord;
    }

    public void computeHighlighting() {
        final String str = this.text.getText();
        double estimatedScrollY = this.text.getEstimatedScrollY();
        if (this.pause.get()) {
            return;
        }
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = new AsyncTask<Void, Void, Object>(){

            public Object doInBackground(Void[] params) {
                Matcher matcher = PATTERN.matcher(str.toUpperCase());
                BetterSpanBuilder builder = new BetterSpanBuilder();
                while (matcher.find()) {
                    Iterator<CodeErrorElement> styleClass;
                    if (this.isCancelled()) {
                        return null;
                    }
                    Object object = matcher.group("INSTRUCTION") != null ? "instruction" : (matcher.group("DIRECTIVE") != null ? "directive" : (matcher.group("ALIAS") != null ? "alias" : (matcher.group("NUMBER") != null ? "number" : (matcher.group("COMMENT") != null ? "comment" : (styleClass = matcher.group("DOLLAR") != null ? "dollar-thingy" : null)))));
                    assert (styleClass != null);
                    int offset = ((String)((Object)styleClass)).equalsIgnoreCase("number") ? 1 : 0;
                    builder.addStyle((String)((Object)styleClass), matcher.start() + offset, matcher.end());
                }
                for (CodeCollisionElement collision : SyntaxHighlighter.this.codeView.getSyntaxAnalysis().getCollisions()) {
                    if (this.isCancelled()) {
                        return null;
                    }
                    if (collision instanceof ReservedAddressCollisionElement) {
                        builder.addStyle("warning", collision.getDefinitionStart(), collision.getDefinitionEnd());
                        continue;
                    }
                    for (TextRange range : collision.getRanges()) {
                        builder.addStyle("warning", range.getStart(), range.getEnd());
                    }
                }
                for (CodeErrorElement error : SyntaxHighlighter.this.codeView.getSyntaxAnalysis().getErrors()) {
                    if (this.isCancelled()) {
                        return null;
                    }
                    builder.addStyle("error", error.getDefinitionStart(), error.getDefinitionEnd());
                }
                if (Settings.getInstance().isExperimental()) {
                    if (!SyntaxHighlighter.this.highlightWord.isEmpty()) {
                        if (this.isCancelled()) {
                            return null;
                        }
                        String regex = "\\b" + SyntaxHighlighter.this.highlightWord + "\\b";
                        Matcher clickables = Pattern.compile(regex).matcher(str);
                        while (clickables.find()) {
                            builder.addStyle("highlight", clickables.start(), clickables.end());
                        }
                    }
                    if (SyntaxHighlighter.this.showClickables.get()) {
                        ArrayList<String> list = new ArrayList<String>();
                        Collections.addAll(list, INSTRUCTIONS);
                        for (FieldElement fieldElement : SyntaxHighlighter.this.codeView.getSyntaxAnalysis().getFields()) {
                            list.add(fieldElement.getName());
                        }
                        for (RoutineElement routineElement : SyntaxHighlighter.this.codeView.getSyntaxAnalysis().getRoutines()) {
                            list.add(routineElement.getName());
                        }
                        CharSequence[] arr = list.toArray(new CharSequence[0]);
                        String regex = "\\b" + String.join((CharSequence)"|", arr) + "\\b";
                        Matcher clickables = Pattern.compile(regex).matcher(str);
                        while (clickables.find()) {
                            if (this.isCancelled()) {
                                return null;
                            }
                            builder.addStyle("clickable", clickables.start(), clickables.end());
                        }
                    }
                    return builder.createStyleSpans(str);
                }
                return builder.createStyleSpans(str);
            }

            @Override
            public void onPostExecute(Object result) {
                if (this.isCancelled() || result == null) {
                    return;
                }
                try {
                    if (result instanceof ArrayList) {
                        for (BetterSpanBuilder.StylizedRange stylizedRange : (ArrayList)result) {
                            SyntaxHighlighter.this.text.setStyle(stylizedRange.getStart(), stylizedRange.getEnd(), stylizedRange.getStyles());
                        }
                    } else if (result instanceof StyleSpans) {
                        SyntaxHighlighter.this.text.setStyleSpans(0, (StyleSpans)result);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.task.execute((Void[])new Void[0]);
    }

    public void setPause(boolean value) {
        this.pause.set(value);
    }

    public void setShowClickables(boolean value) {
        this.showClickables.set(value);
    }
}

