/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem.syntax;

import com.stirante.asem.syntax.ArgumentVerifier;
import com.stirante.asem.syntax.code.CodeCollisionElement;
import com.stirante.asem.syntax.code.CodeErrorElement;
import com.stirante.asem.syntax.code.FieldElement;
import com.stirante.asem.syntax.code.ReservedAddressCollisionElement;
import com.stirante.asem.syntax.code.RoutineElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SyntaxAnalyzer {
    private static final Pattern FIELD = Pattern.compile("(\\w+)\\s+(\\w+)\\s+([\\w.-]+)\\s*;*(.*)");
    private static final Pattern ROUTINE = Pattern.compile("\\s*(\\w+):\\s*;*(.*)");
    private static final Pattern OPERATION = Pattern.compile("\\s*([a-zA-Z]+)\\s+([@a-zA-Z0-9_,# /+*.-]*[a-zA-Z0-9._])\\s*;*.*");
    private static final HashMap<Integer, String> RESERVED_ADDRESSES = new HashMap();

    public static AnalysisResult analyze(String source) {
        String line;
        int i;
        String[] lines = source.split("\n");
        AnalysisResult result = new AnalysisResult();
        int lineOffset = 0;
        for (i = 0; i < lines.length; ++i) {
            line = lines[i];
            Matcher fieldMatcher = FIELD.matcher(line);
            if (fieldMatcher.matches()) {
                result.fields.add(new FieldElement(lineOffset + fieldMatcher.start(1), lineOffset + fieldMatcher.end(1), i + 1, fieldMatcher.group(1), fieldMatcher.group(2).toUpperCase(), fieldMatcher.group(3), fieldMatcher.group(4)));
                lineOffset += line.length() + 1;
                continue;
            }
            Matcher routineMatcher = ROUTINE.matcher(line);
            if (routineMatcher.matches()) {
                result.routines.add(new RoutineElement(lineOffset + routineMatcher.start(1), lineOffset + routineMatcher.end(1), i + 1, routineMatcher.group(1), routineMatcher.group(2)));
            }
            lineOffset += line.length() + 1;
        }
        lineOffset = 0;
        for (i = 0; i < lines.length; ++i) {
            String args;
            String mnemonic;
            Object matchType;
            line = lines[i];
            Matcher operationMatcher = OPERATION.matcher(line);
            if (operationMatcher.matches() && (matchType = ArgumentVerifier.checkStatus(mnemonic = operationMatcher.group(1).toUpperCase(), args = operationMatcher.group(2).replaceAll(" ", ""), result.fields, result.routines)) != ArgumentVerifier.MatchType.MATCH) {
                String desc = matchType == ArgumentVerifier.MatchType.UNKNOWN_SYMBOL ? "Unknown symbol!" : "Invalid arguments!";
                CodeErrorElement e = new CodeErrorElement(lineOffset + operationMatcher.start(1), lineOffset + operationMatcher.end(2), i + 1, desc);
                result.errors.add(e);
            }
            lineOffset += line.length() + 1;
        }
        ArrayList<CodeCollisionElement> c = new ArrayList<CodeCollisionElement>();
        for (FieldElement field : result.fields) {
            int address;
            if (field.getFieldType().equalsIgnoreCase("equ") || (address = SyntaxAnalyzer.parseAddress(field.getValue())) == -1) continue;
            boolean found = false;
            for (CodeCollisionElement collision2 : c) {
                if (collision2.getAddress() != address) continue;
                collision2.addCollision(field.getDefinitionStart(), field.getDefinitionEnd(), field.getDefinitionLine());
                found = true;
            }
            if (!found) {
                CodeCollisionElement e = new CodeCollisionElement(field.getDefinitionStart(), field.getDefinitionEnd(), field.getDefinitionLine(), address);
                c.add(e);
            }
            if (!RESERVED_ADDRESSES.containsKey(address)) continue;
            c.add(new ReservedAddressCollisionElement(field.getDefinitionStart(), field.getDefinitionEnd(), field.getDefinitionLine(), address, RESERVED_ADDRESSES.get(address)));
        }
        result.collisions.addAll(c.stream().filter(collision -> collision.getRanges().size() > 1 || collision instanceof ReservedAddressCollisionElement).collect(Collectors.toList()));
        return result;
    }

    private static int parseAddress(String s) {
        String a = s.replace("#", "");
        if (a.contains("b")) {
            try {
                return Integer.parseInt(a.replaceAll("b", ""), 2);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        if (a.contains("h")) {
            try {
                return Integer.parseInt(a.replaceAll("h", ""), 16);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        try {
            return Integer.parseInt(a.replaceAll("d", ""));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    static {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(SyntaxAnalyzer.class.getResourceAsStream("/reserved_addresses.csv")));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] split = line.split(",");
                String name = split[0];
                Integer address = Integer.parseInt(split[1].replaceAll("h", ""), 16);
                RESERVED_ADDRESSES.put(address, name);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class AnalysisResult {
        private ArrayList<FieldElement> fields = new ArrayList();
        private ArrayList<RoutineElement> routines = new ArrayList();
        private ArrayList<CodeCollisionElement> collisions = new ArrayList();
        private ArrayList<CodeErrorElement> errors = new ArrayList();

        public ArrayList<FieldElement> getFields() {
            return this.fields;
        }

        public ArrayList<RoutineElement> getRoutines() {
            return this.routines;
        }

        public ArrayList<CodeCollisionElement> getCollisions() {
            return this.collisions;
        }

        public ArrayList<CodeErrorElement> getErrors() {
            return this.errors;
        }
    }
}

