/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem.syntax;

import com.stirante.asem.syntax.MnemonicArguments;
import com.stirante.asem.syntax.code.FieldElement;
import com.stirante.asem.syntax.code.RoutineElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArgumentVerifier {
    public static MatchType checkStatus(String mnemonic, String args, ArrayList<FieldElement> fields, ArrayList<RoutineElement> routines) {
        Field[] fs;
        String[] split = args.split(",");
        for (Field f : fs = MnemonicArguments.class.getDeclaredFields()) {
            if (!f.getName().equals(mnemonic) || f.getType() != Type[][].class) continue;
            try {
                Type[][] arr;
                f.setAccessible(true);
                for (Type[] types : arr = (Type[][])f.get(null)) {
                    if (types.length != split.length) continue;
                    int match = 0;
                    for (int i = 0; i < types.length; ++i) {
                        MatchType type = types[i].matches(split[i], fields, routines);
                        if (type == MatchType.MATCH) {
                            ++match;
                            continue;
                        }
                        if (type != MatchType.UNKNOWN_SYMBOL) continue;
                        return type;
                    }
                    if (match == types.length) {
                        return MatchType.MATCH;
                    }
                    return MatchType.NOT_MATCH;
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return MatchType.MATCH;
    }

    static enum MatchType {
        MATCH,
        NOT_MATCH,
        UNKNOWN_SYMBOL;

    }

    static enum Type {
        A_B("[aA][bB]"),
        AT_R0("@[rR]0"),
        AT_R1("@[rR]1"),
        C("[cC]"),
        R0("[rR]0"),
        R1("[rR]1"),
        R2("[rR]2"),
        R3("[rR]3"),
        R4("[rR]4"),
        R5("[rR]5"),
        R6("[rR]6"),
        R7("[rR]7"),
        BIT_ADDR(".+"),
        IRAM_ADDR(".+"),
        CODE_ADDR("([a-zA-Z0-9_]+)"),
        DATA("#([0-9abcdefABCDEF]+[hH]|[0-9]+[dD]?|[01]+[bB])"),
        DATA_16("#([0-9abcdefABCDEF]+[hH]|[0-9]+[dD]?|[01]+[bB])"),
        DPTR("[dD][pP][tT][rR]"),
        A("[aA]");

        private final Pattern pattern;

        private Type(String regex) {
            this.pattern = Pattern.compile("^" + regex + "$");
        }

        MatchType matches(String str, ArrayList<FieldElement> fields, ArrayList<RoutineElement> routines) {
            Matcher matcher = this.pattern.matcher(str);
            if (matcher.matches() && matcher.groupCount() == 1) {
                String routine = matcher.group(1);
                for (RoutineElement routineElement : routines) {
                    if (!routineElement.getName().equalsIgnoreCase(routine)) continue;
                    return MatchType.MATCH;
                }
                return MatchType.UNKNOWN_SYMBOL;
            }
            if (matcher.matches()) {
                return MatchType.MATCH;
            }
            return MatchType.NOT_MATCH;
        }
    }
}

