/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.asem;

import com.stirante.asem.ui.ByteCreator;
import com.stirante.asem.ui.CodeView;
import com.stirante.asem.ui.CompileOutputView;
import com.stirante.asem.ui.FindDialog;
import com.stirante.asem.ui.HelpDialog;
import com.stirante.asem.ui.LcdCreator;
import com.stirante.asem.ui.ReplaceDialog;
import com.stirante.asem.ui.SegmentCreator;
import com.stirante.asem.ui.Settings;
import com.stirante.asem.utils.AsyncTask;
import com.stirante.asem.utils.UpdateUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Application;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TabPane;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import org.fxmisc.flowless.VirtualizedScrollPane;

public class Main
extends Application {
    private static Stage stage;
    @FXML
    public TabPane tabs;
    @FXML
    public BorderPane result;
    @FXML
    public MenuItem saveMenuItem;
    @FXML
    public Menu byteMenu;
    @FXML
    public MenuItem newMenuItem;
    @FXML
    public MenuItem openMenuItem;
    @FXML
    public MenuItem closeMenuItem;
    @FXML
    public MenuItem undoMenuItem;
    @FXML
    public MenuItem redoMenuItem;
    @FXML
    public MenuItem segmentCreatorItem;
    @FXML
    public MenuItem lcdCreatorItem;
    public CompileOutputView compileResult;
    private ByteCreator byteCreator;
    private FindDialog findDialog;
    private ReplaceDialog replaceDialog;

    public static Stage getStage() {
        return stage;
    }

    public static void main(String[] args) {
        Main.launch(args);
    }

    @Override
    public void start(Stage primaryStage) throws Exception {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/MainWindow.fxml"));
        loader.setController(this);
        VBox root = (VBox)loader.load();
        Scene scene = new Scene(root, 1280.0, 720.0);
        scene.getStylesheets().add(this.getClass().getResource("/style.css").toExternalForm());
        primaryStage.setScene(scene);
        primaryStage.setTitle("Assembler Studio");
        primaryStage.setOnCloseRequest(event -> this.tabs.getTabs().forEach(tab -> ((CodeView)tab).onClose()));
        this.tabs.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            this.saveMenuItem.setDisable(newValue == null);
            this.byteMenu.setDisable(newValue == null);
            this.segmentCreatorItem.setDisable(newValue == null);
            this.lcdCreatorItem.setDisable(newValue == null);
            this.compileResult.setText("");
        });
        this.saveMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.S, KeyCombination.CONTROL_DOWN));
        this.newMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.N, KeyCombination.CONTROL_DOWN));
        this.undoMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.Z, KeyCombination.CONTROL_DOWN));
        this.redoMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.Z, KeyCombination.CONTROL_DOWN, KeyCombination.SHIFT_DOWN));
        this.closeMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.Q, KeyCombination.CONTROL_DOWN));
        this.openMenuItem.setAccelerator(new KeyCodeCombination(KeyCode.O, KeyCombination.CONTROL_DOWN));
        root.setOnKeyPressed(event -> {
            if (event.isAltDown()) {
                event.consume();
                return;
            }
            if (event.getCode() == KeyCode.F9) {
                this.onCompileClicked();
            } else if (event.getCode() == KeyCode.F10) {
                this.onRunClicked();
            } else if (event.isControlDown() && event.getCode() == KeyCode.F) {
                if (this.hasOpenTab()) {
                    String selectedText = this.getOpenTab().getSelectedText();
                    this.findDialog.show(selectedText.isEmpty() ? null : selectedText);
                }
            } else if (event.isControlDown() && event.getCode() == KeyCode.R && this.hasOpenTab()) {
                String selectedText = this.getOpenTab().getSelectedText();
                this.replaceDialog.show(selectedText.isEmpty() ? null : selectedText);
            }
        });
        primaryStage.show();
        stage = primaryStage;
        this.findDialog = new FindDialog(this);
        this.replaceDialog = new ReplaceDialog(this);
        this.byteCreator = new ByteCreator();
        this.compileResult = new CompileOutputView(this);
        this.result.setCenter(new VirtualizedScrollPane<CompileOutputView>(this.compileResult));
        root.setOnDragOver(event -> {
            if (event.getGestureSource() != root && event.getDragboard().hasFiles()) {
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            }
            event.consume();
        });
        root.setOnDragDropped(event -> {
            Dragboard db = event.getDragboard();
            System.out.println(db.getFiles());
            boolean success = false;
            if (db.hasFiles()) {
                db.getFiles().forEach(this::openFile);
                success = true;
            }
            event.setDropCompleted(success);
            event.consume();
        });
        List<String> args = this.getParameters().getUnnamed();
        if (!args.isEmpty()) {
            this.openFile(new File(args.get(0)));
        }
        try {
            UpdateUtil.check(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openFile(File f) {
        CodeView tab = new CodeView(this, f);
        if (!this.tabs.getTabs().contains(tab)) {
            this.tabs.getTabs().add(tab);
            this.tabs.getSelectionModel().select(tab);
        } else {
            this.tabs.getSelectionModel().select(tab);
        }
    }

    public void onOpenClicked() {
        File value;
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open file");
        String path = Settings.getInstance().getLastPath();
        if (path != null && !path.isEmpty() && (value = new File(path)).exists()) {
            fileChooser.setInitialDirectory(value);
        }
        fileChooser.getExtensionFilters().addAll((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("ASM file", "*.asm"), new FileChooser.ExtensionFilter("All files", "*.*")});
        File f = fileChooser.showOpenDialog(stage);
        if (f != null) {
            Settings.getInstance().setLastPath(f.getParentFile().getAbsolutePath());
            this.openFile(f);
        }
    }

    public void onCloseClicked() {
        stage.close();
    }

    public void onAboutClicked() {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.getDialogPane().getStylesheets().add(this.getClass().getResource("/style.css").toExternalForm());
        alert.setTitle("About");
        alert.setHeaderText("Assembler Studio v.1.9");
        alert.setContentText("Author: Piotr \"stirante\" Brzozowski");
        alert.showAndWait();
    }

    public void onDonateClicked() {
        this.getHostServices().showDocument("https://paypal.me/stirante");
    }

    public void onCompileClicked() {
        if (this.hasOpenTab()) {
            if (!this.getOpenTab().save()) {
                this.compileResult.setText("You need to save file first!");
                return;
            }
            new AsyncTask<Void, Void, String>(){

                public String doInBackground(Void[] params) {
                    return Main.this.getOpenTab().compile();
                }

                @Override
                public void onPostExecute(String compileResult) {
                    Main.this.compileResult.setText(compileResult);
                }
            }.execute(new Void[0]);
        }
    }

    public void onSendClicked() {
        if (this.hasOpenTab()) {
            if (!this.getOpenTab().save()) {
                this.compileResult.setText("You need to save and compile file first!");
                return;
            }
            this.compileResult.setText(this.getOpenTab().sendHex());
        }
    }

    public String onSetBiosClicked() {
        File file = new File("bin/set_bios.exe");
        ProcessBuilder pb = new ProcessBuilder(file.getAbsolutePath());
        pb.directory(file.getParentFile());
        try {
            pb.start();
            return "Set bios started";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "Failed to run set bios!\n" + e.getMessage();
        }
    }

    public void onSaveClicked() {
        if (this.hasOpenTab()) {
            this.getOpenTab().save();
        }
    }

    public void undo() {
        if (this.hasOpenTab()) {
            this.getOpenTab().undo();
        }
    }

    public void redo() {
        if (this.hasOpenTab()) {
            this.getOpenTab().redo();
        }
    }

    public boolean hasOpenTab() {
        return this.tabs.getSelectionModel().getSelectedItem() != null;
    }

    public CodeView getOpenTab() {
        return (CodeView)this.tabs.getSelectionModel().getSelectedItem();
    }

    public void byteCreatorTmod() {
        if (this.hasOpenTab()) {
            ArrayList<String> descs = new ArrayList<String>();
            descs.add(0, "Timer 0\n\nM0\nThe last bits third and fourth are known as M1 and M0 respectively. These are used to select the timer mode.");
            descs.add(1, "Timer 0\n\nM1\nThe last bits third and fourth are known as M1 and M0 respectively. These are used to select the timer mode.");
            descs.add(2, "Timer 0\n\nC/T\nC/T bit is used to decide whether a timer is used as a time delay generator or an event counter. If this bit is 0 then it is used as a timer and if it is 1 then it is used as a counter.");
            descs.add(3, "Timer 0\n\nGATE\nThe hardware way of starting and stopping the timer by an external source is achieved by making GATE=1 in the TMOD register. And if we change to GATE=0 then we do no need external hardware to start and stop the timers.");
            descs.add(4, "Timer 1\n\nM0\nThe last bits third and fourth are known as M1 and M0 respectively. These are used to select the timer mode.");
            descs.add(5, "Timer 1\n\nM1\nThe last bits third and fourth are known as M1 and M0 respectively. These are used to select the timer mode.");
            descs.add(6, "Timer 1\n\nC/T\nC/T bit is used to decide whether a timer is used as a time delay generator or an event counter. If this bit is 0 then it is used as a timer and if it is 1 then it is used as a counter.");
            descs.add(7, "Timer 1\n\nGATE\nThe hardware way of starting and stopping the timer by an external source is achieved by making GATE=1 in the TMOD register. And if we change to GATE=0 then we do no need external hardware to start and stop the timers.");
            String bits = this.byteCreator.create("TMOD", descs);
            this.getOpenTab().insert(bits);
        }
    }

    public void byteCreatorTcon() {
        if (this.hasOpenTab()) {
            ArrayList<String> descs = new ArrayList<String>();
            descs.add(0, "IT0\nExternal interrupt 0 signal type control bit. Same as IT0.");
            descs.add(1, "IE0\nExternal interrupt 0 Edge flag. Not related to timer operations.");
            descs.add(2, "IT1\nExternal interrupt1 signal type control bit. Set to 1 by program to enable external interrupt 1 to be triggered by a falling edge signal. Set to 0 by program to enable a low level signal on external interrupt1 to generate an interrupt.");
            descs.add(3, "IE1\nExternal interrupt 1 Edge flag. Not related to timer operations.");
            descs.add(4, "TR0\nTimer 0 run control bit.  Same as TR1.");
            descs.add(5, "TF0\nTimer 0 over flow flag. Same as TF1.");
            descs.add(6, "TR1\nTimer 1 run control bit. Set to 1 by programmer to enable timer to count; Cleared to 0 by program to halt timer.");
            descs.add(7, "TF1\nTimer1 over flow flag. Set when timer rolls from all 1s to 0. Cleared when the processor vectors to execute interrupt service routine. Located at program address 001Bh.");
            String bits = this.byteCreator.create("TCON", descs);
            this.getOpenTab().insert(bits);
        }
    }

    public void byteCreatorIe() {
        if (this.hasOpenTab()) {
            ArrayList<String> descs = new ArrayList<String>();
            descs.add(0, "EX0\nEnable External 0 Interrupt");
            descs.add(1, "ET0\nEnable Timer 0 Interrupt");
            descs.add(2, "EX1\nEnable External 1 Interrupt");
            descs.add(3, "ET1\nEnable Timer 1 Interrupt");
            descs.add(4, "ES\nEnable Serial Interrupt");
            descs.add(5, "Undefined");
            descs.add(6, "Undefined");
            descs.add(7, "EA\nGlobal Interrupt Enable/Disable");
            String bits = this.byteCreator.create("IE", descs);
            this.getOpenTab().insert(bits);
        }
    }

    public void onNewClicked() {
        this.openFile(null);
    }

    public void onRunClicked() {
        if (this.hasOpenTab()) {
            if (!this.getOpenTab().save()) {
                this.compileResult.setText("You need to save and compile file first!");
                return;
            }
            this.compileResult.setText(this.getOpenTab().run());
        }
    }

    public void segmentCreator() {
        if (this.hasOpenTab()) {
            String bits = SegmentCreator.create();
            this.getOpenTab().insert(bits);
        }
    }

    public void onSettingsClicked() {
        Settings.getInstance().show();
    }

    public void onKeyboardHelpClicked() {
        HelpDialog.show();
    }

    public void onForceUpdateClicked() {
        try {
            Runtime.getRuntime().exec("java -jar SimpleUpdater.jar check .");
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void lcdCreator() {
        if (this.hasOpenTab()) {
            String bits = LcdCreator.create();
            this.getOpenTab().insert(bits);
        }
    }
}

