/*
 * Decompiled with CFR 0.152.
 */
package com.fo.controls.fontpicker;

import com.fo.controls.fontpicker.FontPicker;
import com.fo.controls.fontpicker.FontPickerBehavior;
import com.fo.controls.fontpicker.FontPickerContent;
import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import javafx.scene.Node;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.text.Font;
import javafx.util.StringConverter;

public class FontPickerSkin
extends ComboBoxPopupControl<Font> {
    private final Label displayNode;
    private FontPicker fontPicker;
    private FontPickerContent fontPickerContent;

    public FontPickerSkin(FontPicker fontPicker) {
        super((ComboBoxBase)fontPicker, (ComboBoxBaseBehavior)new FontPickerBehavior(fontPicker));
        this.fontPicker = fontPicker;
        this.registerChangeListener(fontPicker.valueProperty(), "VALUE");
        this.displayNode = new Label("");
        this.displayNode.getStyleClass().add("font-label");
        this.displayNode.setManaged(false);
        this.updateFont();
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("VALUE".equals(p)) {
            this.updateFont();
        }
    }

    private void updateFont() {
        FontPicker fontPicker = (FontPicker)this.getSkinnable();
        Font font = (Font)fontPicker.getValue();
        String fontText = font.getFamily() + ", " + font.getStyle() + ", " + (int)font.getSize();
        this.displayNode.setText(fontText);
    }

    public void syncWithAutoUpdate() {
        if (!this.getPopup().isShowing() && ((ComboBoxBase)this.getSkinnable()).isShowing()) {
            ((ComboBoxBase)this.getSkinnable()).hide();
        }
    }

    protected Node getPopupContent() {
        if (this.fontPickerContent == null) {
            this.fontPickerContent = new FontPickerContent(this.fontPicker);
        }
        return this.fontPickerContent;
    }

    protected TextField getEditor() {
        return null;
    }

    protected StringConverter<Font> getConverter() {
        return null;
    }

    public Node getDisplayNode() {
        return this.displayNode;
    }
}

