/*
 * Decompiled with CFR 0.152.
 */
package com.fo.controls.fontpicker;

import com.fo.controls.fontpicker.FontPicker;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Spinner;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.RowConstraints;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.util.StringConverter;

public class FontPickerContent
extends GridPane {
    private Font newFont;
    private Label previewLabel;
    private ComboBox<String> fontComboBox;
    private Spinner<Integer> sizeSpinner;
    private CheckBox boldCheckBox;
    private CheckBox italicCheckBox;
    private FontPicker fontPicker;

    public FontPickerContent(FontPicker fontPicker) {
        this.fontPicker = fontPicker;
        this.getStyleClass().add("font-picker-popup");
        this.initGui();
    }

    private void initGui() {
        this.newFont = (Font)this.fontPicker.getValue();
        this.setPrefSize(200.0, 230.0);
        this.getStylesheets().addAll((String[])new String[]{this.getClass().getResource("/style.css").toExternalForm(), this.getClass().getResource("/font-picker.css").toExternalForm()});
        this.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{new ColumnConstraints(40.0), new ColumnConstraints(160.0)});
        this.getRowConstraints().addAll((RowConstraints[])new RowConstraints[]{new RowConstraints(20.0), new RowConstraints(35.0), new RowConstraints(35.0), new RowConstraints(35.0), new RowConstraints(30.0), new RowConstraints(30.0), new RowConstraints(30.0)});
        this.add(new Label("Preview:"), 0, 0, 2, 1);
        this.previewLabel = new Label("ABCDEF abcdef 0123456");
        this.previewLabel.setMaxWidth(Double.MAX_VALUE);
        this.previewLabel.setMaxHeight(Double.MAX_VALUE);
        this.previewLabel.setFont(this.newFont);
        this.previewLabel.getStyleClass().add("preview-label");
        this.add(this.previewLabel, 0, 1, 2, 2);
        this.add(new Label("Font:"), 0, 3, 1, 1);
        List<String> families = Font.getFamilies();
        this.fontComboBox = new ComboBox<String>(FXCollections.observableList(families));
        this.fontComboBox.setMaxWidth(Double.MAX_VALUE);
        this.add(this.fontComboBox, 1, 3, 1, 1);
        this.add(new Label("Size:"), 0, 4, 1, 1);
        this.sizeSpinner = new Spinner(1, 100, 12);
        this.sizeSpinner.setEditable(true);
        this.sizeSpinner.setPrefWidth(70.0);
        this.sizeSpinner.getValueFactory().setValue((int)this.newFont.getSize());
        this.add(this.sizeSpinner, 1, 4, 1, 1);
        this.add(new Label("Style:"), 0, 5, 1, 1);
        this.boldCheckBox = new CheckBox("Bold");
        this.italicCheckBox = new CheckBox("Italic");
        HBox styleHBox = new HBox(10.0);
        styleHBox.setAlignment(Pos.CENTER_LEFT);
        styleHBox.getChildren().addAll((Node[])new Node[]{this.boldCheckBox, this.italicCheckBox});
        this.add(styleHBox, 1, 5, 1, 1);
        Button okButton = new Button("OK");
        okButton.setPrefWidth(55.0);
        Button cancelButton = new Button("Cancel");
        cancelButton.setPrefWidth(55.0);
        HBox buttonsHBox = new HBox(5.0);
        buttonsHBox.setAlignment(Pos.CENTER_RIGHT);
        buttonsHBox.getChildren().addAll((Node[])new Node[]{okButton, cancelButton});
        this.add(buttonsHBox, 1, 6, 1, 1);
        for (String s : this.fontComboBox.getItems()) {
            if (!s.equals(this.newFont.getFamily())) continue;
            this.fontComboBox.getSelectionModel().select(s);
            break;
        }
        this.fontComboBox.valueProperty().addListener(observable -> this.changeFont());
        this.fontComboBox.setCellFactory(listView -> {
            ListCell<String> cell = new ListCell<String>(){

                @Override
                public void updateItem(String item, boolean empty) {
                    super.updateItem(item, empty);
                    if (item != null) {
                        this.setText(item);
                        this.setFont(new Font(item, 12.0));
                    }
                }
            };
            cell.setPrefWidth(120.0);
            return cell;
        });
        StringConverter<Integer> spinnerFormatter = new StringConverter<Integer>(){

            @Override
            public Integer fromString(String val) {
                String oldVal = String.valueOf(FontPickerContent.this.sizeSpinner.getValue());
                try {
                    int result = Integer.parseInt(val);
                    if (result >= 1 && result <= 100) {
                        return result;
                    }
                    throw new Exception("");
                }
                catch (Exception e) {
                    FontPickerContent.this.sizeSpinner.getEditor().setText(oldVal);
                    return (Integer)FontPickerContent.this.sizeSpinner.getValue();
                }
            }

            @Override
            public String toString(Integer val) {
                return val.toString();
            }
        };
        this.sizeSpinner.getValueFactory().setConverter(spinnerFormatter);
        this.sizeSpinner.valueProperty().addListener(observable -> this.changeFont());
        this.boldCheckBox.selectedProperty().addListener(observable -> this.changeFont());
        this.italicCheckBox.selectedProperty().addListener(observable -> this.changeFont());
        okButton.setOnAction(event -> {
            this.fontPicker.setValue(this.newFont);
            this.fontPicker.hide();
        });
        cancelButton.setOnAction(event -> this.fontPicker.hide());
        this.changeFont();
    }

    private void changeFont() {
        Font font;
        FontWeight weight = this.boldCheckBox.isSelected() ? FontWeight.BOLD : FontWeight.NORMAL;
        FontPosture posture = this.italicCheckBox.isSelected() ? FontPosture.ITALIC : FontPosture.REGULAR;
        int size = this.sizeSpinner.getValue();
        String family = (String)this.fontComboBox.getValue();
        this.newFont = font = Font.font(family, weight, posture, size);
        this.previewLabel.setFont(font);
    }
}

