/*
 * Decompiled with CFR 0.152.
 */
package com.fo.controls.fontpicker;

import com.fo.controls.fontpicker.FontPicker;
import com.fo.controls.fontpicker.FontPickerSkin;
import com.sun.javafx.scene.control.behavior.ComboBoxBaseBehavior;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.text.Font;

public class FontPickerBehavior
extends ComboBoxBaseBehavior<Font> {
    protected static final String OPEN_ACTION = "Open";
    protected static final String CLOSE_ACTION = "Close";
    protected static final List<KeyBinding> FONT_PICKER_BINDINGS = new ArrayList<KeyBinding>();

    public FontPickerBehavior(FontPicker fontPicker) {
        super((ComboBoxBase)fontPicker, FONT_PICKER_BINDINGS);
    }

    protected void callAction(String name) {
        switch (name) {
            case "Open": {
                this.show();
                break;
            }
            case "Close": {
                this.hide();
                break;
            }
            default: {
                super.callAction(name);
            }
        }
    }

    public void onAutoHide() {
        FontPicker fontPicker = (FontPicker)this.getControl();
        FontPickerSkin fontPickerSkin = (FontPickerSkin)((Object)fontPicker.getSkin());
        fontPickerSkin.syncWithAutoUpdate();
        if (!fontPicker.isShowing()) {
            super.onAutoHide();
        }
    }

    static {
        FONT_PICKER_BINDINGS.add(new KeyBinding(KeyCode.ESCAPE, KeyEvent.KEY_PRESSED, CLOSE_ACTION));
        FONT_PICKER_BINDINGS.add(new KeyBinding(KeyCode.SPACE, KeyEvent.KEY_PRESSED, OPEN_ACTION));
        FONT_PICKER_BINDINGS.add(new KeyBinding(KeyCode.ENTER, KeyEvent.KEY_PRESSED, OPEN_ACTION));
    }
}

