/*
 * Decompiled with CFR 0.152.
 */
package com.stirante.updater.utils;

import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;

public abstract class AsyncTask<P, T, R> {
    private AtomicBoolean cancelled = new AtomicBoolean(false);
    private AtomicBoolean done = new AtomicBoolean(false);

    @SafeVarargs
    public final void execute(final P ... params) {
        new Thread(){

            @Override
            public void run() {
                Object result = AsyncTask.this.doInBackground(params);
                AsyncTask.this.done.set(true);
                if (!AsyncTask.this.isCancelled()) {
                    Platform.runLater(() -> AsyncTask.this.onPostExecute(result));
                }
                if (AsyncTask.this.isCancelled()) {
                    Platform.runLater(() -> AsyncTask.this.onCancel());
                }
            }
        }.start();
    }

    public void onProgress(T progress) {
    }

    public final void publishProgress(T progress) {
        Platform.runLater(() -> this.onProgress(progress));
    }

    public abstract R doInBackground(P[] var1);

    public void onPostExecute(R result) {
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    public void onCancel() {
    }

    public boolean isDone() {
        return this.done.get();
    }

    public void cancel() {
        this.cancelled.set(true);
    }
}

